/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.util.Locale;
import org.tentackle.common.LocaleProvider$Singleton;
import org.tentackle.common.Service;
import org.tentackle.common.TentackleRuntimeException;

@Service(value=LocaleProvider.class)
public class LocaleProvider {
    private final ThreadLocal<Locale> tlLocale = new ThreadLocal();

    public static LocaleProvider getInstance() {
        return LocaleProvider$Singleton.INSTANCE;
    }

    public Locale getCurrentLocale() {
        return this.tlLocale.get();
    }

    public Locale getLocale() {
        Locale locale = this.getCurrentLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public void setCurrentLocale(Locale locale) {
        this.tlLocale.set(locale);
    }

    public void assertCurrentLocaleValid() {
        if (this.getCurrentLocale() == null) {
            throw new TentackleRuntimeException("no thread local Locale");
        }
    }

    public Locale getEffectiveLocale(Locale locale) {
        return locale;
    }

    public Locale getEffectiveLocale() {
        return this.getEffectiveLocale(this.getLocale());
    }
}

