/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.appupdate;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wiztools.appupdate.Version;

public class VersionImpl
implements Version {
    private static final String regex = "^([0-9]+)(\\.([0-9]+))?(\\.([0-9]+))?$";
    private final String stringRepresentation;
    private final int major;
    private final int minor;
    private final int patch;

    public VersionImpl(String vStr) {
        this.stringRepresentation = vStr;
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(vStr);
        if (m.matches()) {
            this.major = Integer.parseInt(m.group(1));
            String minorStr = m.group(3);
            this.minor = minorStr != null && !minorStr.equals("") ? Integer.parseInt(minorStr) : 0;
            String patchStr = m.group(5);
            this.patch = patchStr != null && !patchStr.equals("") ? Integer.parseInt(patchStr) : 0;
        } else {
            throw new IllegalArgumentException("Invalid version string: " + vStr);
        }
    }

    public String toString() {
        return this.stringRepresentation;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public int getPatch() {
        return this.patch;
    }

    @Override
    public boolean isLessThan(Version v) {
        if (this.getMajor() < v.getMajor()) {
            return true;
        }
        if (this.getMajor() == v.getMajor()) {
            if (this.getMinor() < v.getMinor()) {
                return true;
            }
            if (this.getMinor() == v.getMinor() && this.getPatch() < v.getPatch()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isGreaterThan(Version v) {
        if (this.getMajor() > v.getMajor()) {
            return true;
        }
        if (this.getMajor() == v.getMajor()) {
            if (this.getMinor() > v.getMinor()) {
                return true;
            }
            if (this.getMinor() == v.getMinor() && this.getPatch() > v.getPatch()) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.stringRepresentation);
        hash = 97 * hash + this.major;
        hash = 97 * hash + this.minor;
        hash = 97 * hash + this.patch;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionImpl other = (VersionImpl)obj;
        if (!Objects.equals(this.stringRepresentation, other.stringRepresentation)) {
            return false;
        }
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return this.patch == other.patch;
    }
}

