/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.deployer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.internal.ApplicationManager;

public class AppDeployerBundleListener
implements BundleListener {
    private static Log log = LogFactory.getLog(AppDeployerBundleListener.class);
    private static AppDeployerBundleListener instance = null;
    private ApplicationManager appManager;

    private AppDeployerBundleListener(ApplicationManager appManager) {
        this.appManager = appManager;
    }

    public static AppDeployerBundleListener getInstance(ApplicationManager appManager) {
        if (instance == null) {
            instance = new AppDeployerBundleListener(appManager);
        }
        return instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void bundleChanged(BundleEvent bundleEvent) {
        try {
            Bundle currentBundle = bundleEvent.getBundle();
            String appName = AppDeployerUtils.getProjectArtifactName(currentBundle);
            if (bundleEvent.getType() == 32 && appName == null) return;
        }
        catch (Exception e) {
            log.error((Object)"Couldn't deploy Carbon App properly", (Throwable)e);
        }
    }
}

