/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.deployer.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.config.RegistryConfig;
import org.wso2.carbon.application.deployer.internal.AppDeployerServiceComponent;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.MediaTypesUtils;
import org.wso2.carbon.registry.synchronization.RegistrySynchronizer;
import org.wso2.carbon.roles.mgt.ServerRoleUtils;

public class CarbonAppPersistenceManager {
    private AxisConfiguration axisConfig;
    private Registry localRegistry;
    private Registry configRegistry;
    private Registry governanceRegistry;
    private Registry rootRegistry;
    private static final Log log = LogFactory.getLog(CarbonAppPersistenceManager.class);

    public CarbonAppPersistenceManager(AxisConfiguration axisConfig) throws CarbonException {
        this.axisConfig = axisConfig;
        try {
            PrivilegedCarbonContext carbonCtx = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            this.localRegistry = (Registry)carbonCtx.getRegistry(RegistryType.LOCAL_REPOSITORY);
            this.configRegistry = (Registry)carbonCtx.getRegistry(RegistryType.SYSTEM_CONFIGURATION);
            this.governanceRegistry = (Registry)carbonCtx.getRegistry(RegistryType.SYSTEM_GOVERNANCE);
            this.rootRegistry = AppDeployerServiceComponent.getRegistryService().getRegistry("wso2.system.user", carbonCtx.getTenantId());
        }
        catch (Exception e) {
            log.error((Object)"Error while retrieving config registry from Axis configuration", (Throwable)e);
        }
        if (this.configRegistry == null) {
            throw new CarbonException("Configuration Registry is not available");
        }
    }

    public String getHashValue(String appNameWithVersion) throws CarbonException {
        try {
            String appResourcePath = "repository/applications/" + appNameWithVersion;
            if (this.configRegistry.resourceExists(appResourcePath)) {
                Resource app = this.configRegistry.get(appResourcePath);
                return app.getProperty("capp.hash.value");
            }
        }
        catch (RegistryException e) {
            String msg = "Unable to read hash value of the Application : " + appNameWithVersion + ". Registry transactions failed.";
            log.error((Object)msg, (Throwable)e);
            throw new CarbonException(msg, (Throwable)e);
        }
        return null;
    }

    public void deleteApplication(String appNameWithVersion) throws Exception {
        try {
            String appResourcePath = "repository/applications/" + appNameWithVersion;
            if (this.configRegistry.resourceExists(appResourcePath)) {
                this.configRegistry.delete(appResourcePath);
            }
        }
        catch (RegistryException e) {
            String msg = "Unable to delete the Application : " + appNameWithVersion + ". Registry transactions failed.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public void removeArtifactResources(RegistryConfig registryConfig) {
        try {
            List<RegistryConfig.Collection> collections = registryConfig.getCollections();
            for (RegistryConfig.Collection col : collections) {
                Registry reg = this.getRegistryInstance(col.getRegistryType());
                if (reg == null || !reg.resourceExists(col.getPath())) continue;
                reg.delete(col.getPath());
            }
            List<RegistryConfig.Dump> dumps = registryConfig.getDumps();
            for (RegistryConfig.Dump dump : dumps) {
                Registry reg = this.getRegistryInstance(dump.getRegistryType());
                if (reg == null || !reg.resourceExists(dump.getPath())) continue;
                reg.delete(dump.getPath());
            }
            if (this.configRegistry.resourceExists("/repository/carbonapps/path_mapping/" + registryConfig.getAppName())) {
                Resource pathMappingResource = this.configRegistry.get("/repository/carbonapps/path_mapping/" + registryConfig.getAppName());
                OMElement pathMappingElement = AXIOMUtil.stringToOM((String)new String((byte[])pathMappingResource.getContent()));
                List<RegistryConfig.Resourse> resources = registryConfig.getResources();
                for (RegistryConfig.Resourse res : resources) {
                    String actualResourcePath;
                    String fileName = res.getFileName();
                    Registry reg = this.getRegistryInstance(res.getRegistryType());
                    String resourcePath = AppDeployerUtils.computeResourcePath(res.getPath(), fileName);
                    AXIOMXPath axiomxPath = new AXIOMXPath("//resource[@path='" + resourcePath + "']");
                    OMElement resourceElement = (OMElement)axiomxPath.selectSingleNode((Object)pathMappingElement);
                    if (resourceElement != null) {
                        OMElement targetElement = resourceElement.getFirstChildWithName(new QName("target"));
                        actualResourcePath = targetElement.getText();
                    } else {
                        actualResourcePath = resourcePath;
                    }
                    if (reg != null && reg.resourceExists(actualResourcePath)) {
                        reg.delete(actualResourcePath);
                        continue;
                    }
                    String mediaType = res.getMediaType();
                    if (mediaType == null) {
                        mediaType = MediaTypesUtils.getMediaType((String)fileName);
                    }
                    if (!"application/vnd.wso2.governance-archive".equals(mediaType)) continue;
                    String garName = fileName.substring(0, fileName.lastIndexOf("."));
                    String garMappingResourcePath = "/repository/carbonapps/gar_mapping/" + garName;
                    if (!this.configRegistry.resourceExists(garMappingResourcePath)) continue;
                    Resource garMappingResource = this.configRegistry.get(garMappingResourcePath);
                    OMElement garMappingElement = AXIOMUtil.stringToOM((String)new String((byte[])garMappingResource.getContent()));
                    axiomxPath = new AXIOMXPath("//gar[@path='" + resourcePath + "']");
                    OMElement garElement = (OMElement)axiomxPath.selectSingleNode((Object)garMappingElement);
                    Iterator garTargetElements = garElement.getChildrenWithLocalName("target");
                    while (garTargetElements.hasNext()) {
                        String targetPath = ((OMElement)garTargetElements.next()).getText();
                        if (!reg.resourceExists(targetPath)) continue;
                        reg.delete(targetPath);
                    }
                    this.configRegistry.delete(garMappingResourcePath);
                }
            }
            List<RegistryConfig.Association> associations = registryConfig.getAssociations();
            for (RegistryConfig.Association association : associations) {
                Registry reg = this.getRegistryInstance(association.getRegistryType());
                if (reg == null) continue;
                reg.removeAssociation(association.getSourcePath(), association.getTargetPath(), association.getAssociationType());
            }
        }
        catch (RegistryException e) {
            log.error((Object)("Error while removing registry resources of the artifact : " + registryConfig.getParentArtifactName()));
        }
        catch (Exception e) {
            log.error((Object)("Error while reading path mapping file for : " + registryConfig.getParentArtifactName()));
        }
    }

    public void writeArtifactResources(RegistryConfig regConfig) throws Exception {
        List<RegistryConfig.Collection> collections = regConfig.getCollections();
        for (RegistryConfig.Collection col : collections) {
            Registry reg = this.getRegistryInstance(col.getRegistryType());
            String dirPath = regConfig.getExtractedPath() + File.separator + "resources" + File.separator + col.getDirectory();
            File file = new File(dirPath);
            if (!file.exists()) {
                log.error((Object)("Specified collection directory not found at : " + dirPath));
                continue;
            }
            if (reg == null) continue;
            RegistrySynchronizer.checkIn((UserRegistry)((UserRegistry)reg), (String)dirPath, (String)col.getPath(), (boolean)true, (boolean)true);
        }
        List<RegistryConfig.Resourse> resources = regConfig.getResources();
        for (RegistryConfig.Resourse resource : resources) {
            String resourcePath;
            String actualResourcePath;
            Registry reg = this.getRegistryInstance(resource.getRegistryType());
            String filePath = regConfig.getExtractedPath() + File.separator + "resources" + File.separator + resource.getFileName();
            File file = new File(filePath);
            if (!file.exists()) {
                log.error((Object)("Specified file to be written as a resource is not found at : " + filePath));
                continue;
            }
            if (reg == null || (actualResourcePath = this.writeFromFile(reg, file, resourcePath = AppDeployerUtils.computeResourcePath(resource.getPath(), resource.getFileName()), resource.getMediaType() != null ? resource.getMediaType() : AppDeployerUtils.readMediaType(regConfig.getExtractedPath(), resource.getFileName()))) == null || resourcePath.equals(actualResourcePath)) continue;
            Resource pathMappingResource = this.configRegistry.get("/repository/carbonapps/path_mapping/" + regConfig.getAppName());
            OMElement element = AXIOMUtil.stringToOM((String)new String((byte[])pathMappingResource.getContent()));
            OMFactory factory = OMAbstractFactory.getOMFactory();
            OMElement resourceElement = factory.createOMElement(new QName("resource"));
            resourceElement.addAttribute(factory.createOMAttribute("path", null, resourcePath));
            OMElement targetElement = factory.createOMElement(new QName("target"));
            targetElement.setText(actualResourcePath);
            resourceElement.addChild((OMNode)targetElement);
            element.addChild((OMNode)resourceElement);
            pathMappingResource.setContent((Object)element.toString());
            this.configRegistry.put("/repository/carbonapps/path_mapping/" + regConfig.getAppName(), pathMappingResource);
        }
        List<RegistryConfig.Dump> dumps = regConfig.getDumps();
        for (RegistryConfig.Dump dump : dumps) {
            Registry reg = this.getRegistryInstance(dump.getRegistryType());
            String filePath = regConfig.getExtractedPath() + File.separator + "resources" + File.separator + dump.getDumpFileName();
            File file = new File(filePath);
            if (!file.exists()) {
                log.error((Object)("Specified file to be written as a dump is not found at : " + filePath));
                continue;
            }
            ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
            zis.getNextEntry();
            InputStreamReader reader = new InputStreamReader(zis);
            if (reg == null) continue;
            reg.restore(dump.getPath(), (Reader)reader);
        }
        List<RegistryConfig.Association> associations = regConfig.getAssociations();
        for (RegistryConfig.Association association : associations) {
            Registry reg = this.getRegistryInstance(association.getRegistryType());
            try {
                if (reg == null) continue;
                reg.addAssociation(association.getSourcePath(), association.getTargetPath(), association.getAssociationType());
            }
            catch (RegistryException e) {
                log.error((Object)("Error while adding the association. Source path : " + association.getSourcePath() + " Target path : " + association.getTargetPath()));
            }
        }
    }

    public String writeFromFile(Registry reg, File file, String registryPath, String mediaType) {
        byte[] content = this.getBytesFromFile(file);
        if (content == null) {
            log.error((Object)"Error while writing file content into Registry. File content is null..");
            return null;
        }
        String resourcePath = null;
        try {
            reg.beginTransaction();
            String fileName = file.getName();
            if (mediaType == null) {
                mediaType = MediaTypesUtils.getMediaType((String)fileName);
            }
            if ("application/vnd.wso2.governance-archive".equals(mediaType)) {
                try {
                    String garName = fileName.substring(0, fileName.lastIndexOf("."));
                    String garMappingResourcePath = "/repository/carbonapps/gar_mapping/" + garName;
                    Resource gar = this.configRegistry.newResource();
                    gar.setUUID(UUID.randomUUID().toString());
                    gar.setContent((Object)"<gar_mapping/>");
                    this.configRegistry.put(garMappingResourcePath, gar);
                }
                catch (Exception e) {
                    log.error((Object)("Error in adding gar mapping file for " + fileName), (Throwable)e);
                }
            }
            Resource resource = reg.newResource();
            resource.setContent((Object)content);
            resource.setMediaType(mediaType);
            resourcePath = reg.put(registryPath, resource);
            reg.commitTransaction();
        }
        catch (RegistryException e) {
            try {
                reg.rollbackTransaction();
            }
            catch (RegistryException e1) {
                log.error((Object)"Error while transaction rollback", (Throwable)e1);
            }
            log.error((Object)("Error while checking in resource to path: " + registryPath + " from file: " + file.getAbsolutePath()), (Throwable)e);
        }
        return resourcePath;
    }

    public void createResourcePathMappingFile(String appName) {
        try {
            String pathMappingResourcePath = "/repository/carbonapps/path_mapping/" + appName;
            Resource resource = this.configRegistry.newResource();
            resource.setUUID(UUID.randomUUID().toString());
            resource.setContent((Object)"<path_mapping/>");
            this.configRegistry.put(pathMappingResourcePath, resource);
        }
        catch (Exception e) {
            log.error((Object)("Error in creating resource path mapping for carbon app " + appName), (Throwable)e);
        }
    }

    public void deleteResourcePathMappingFile(String appName) {
        try {
            String pathMappingResourcePath = "/repository/carbonapps/path_mapping/" + appName;
            this.configRegistry.delete(pathMappingResourcePath);
        }
        catch (Exception e) {
            log.error((Object)("Error in creating resource path mapping for carbon app " + appName), (Throwable)e);
        }
    }

    public void persistRegConfig(String artifactPath, RegistryConfig regConfig) throws Exception {
        if (regConfig == null) {
            return;
        }
        Resource resource = this.configRegistry.newResource();
        File regConfigXml = new File(regConfig.getExtractedPath() + File.separator + regConfig.getConfigFileName());
        resource.setContentStream((InputStream)new FileInputStream(regConfigXml));
        this.configRegistry.put(artifactPath + "/regconfig-xml/", resource);
    }

    public RegistryConfig loadRegistryConfig(String artifactPath) throws Exception {
        return this.loadRegistryConfig(artifactPath, null);
    }

    public RegistryConfig loadRegistryConfig(String artifactPath, String appName) throws Exception {
        Resource artifactResource;
        InputStream xmlStream;
        RegistryConfig regConfig = null;
        String regConfigPath = artifactPath + "/regconfig-xml/";
        if (this.configRegistry.resourceExists(regConfigPath) && (xmlStream = (artifactResource = this.configRegistry.get(regConfigPath)).getContentStream()) != null) {
            regConfig = AppDeployerUtils.populateRegistryConfig(new StAXOMBuilder(xmlStream).getDocumentElement());
        }
        regConfig.setAppName(appName);
        return regConfig;
    }

    public boolean areRolesOverridden() {
        String defaultPath = ServerRoleUtils.getRegistryPath((String)"Default");
        try {
            Resource defResource;
            if (this.configRegistry.resourceExists(defaultPath) && "true".equals((defResource = this.configRegistry.get(defaultPath)).getProperty("modified"))) {
                return true;
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while reading server role resources", (Throwable)e);
        }
        return false;
    }

    public List<String> readServerRoles(String roleType) {
        String rolesPath = ServerRoleUtils.getRegistryPath((String)roleType);
        ArrayList<String> roles = new ArrayList<String>();
        try {
            Resource resource;
            List rolesRead;
            if (this.configRegistry.resourceExists(rolesPath) && (rolesRead = (resource = this.configRegistry.get(rolesPath)).getPropertyValues(roleType)) != null) {
                return rolesRead;
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while reading server role resources", (Throwable)e);
        }
        return roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytesFromFile(File file) {
        FileInputStream is = null;
        byte[] bytes = null;
        try {
            int offset;
            is = new FileInputStream(file);
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                log.error((Object)("File " + file.getName() + "is too large."));
            }
            bytes = new byte[(int)length];
            try {
                int numRead;
                for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
                }
            }
            catch (IOException e) {
                log.error((Object)"Error in reading data", (Throwable)e);
            }
            if (offset < bytes.length) {
                log.error((Object)("Could not completely read file " + file.getName()));
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Expected file: " + file.getName() + " Not found"), (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error in closing the stream", (Throwable)e);
            }
        }
        return bytes;
    }

    private Registry getRegistryInstance(String registryType) {
        Registry registry = null;
        if (registryType == null || "".equals(registryType)) {
            registry = this.rootRegistry;
        } else if ("local".equals(registryType)) {
            registry = this.localRegistry;
        } else if ("config".equals(registryType)) {
            registry = this.configRegistry;
        } else if ("governance".equals(registryType)) {
            registry = this.governanceRegistry;
        }
        return registry;
    }
}

