/*
 * Decompiled with CFR 0.152.
 */
package pub.devrel.easypermissions;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.StringRes;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import pub.devrel.easypermissions.AfterPermissionGranted;
import pub.devrel.easypermissions.RationaleDialogFragment;
import pub.devrel.easypermissions.RationaleDialogFragmentCompat;

public class EasyPermissions {
    private static final String TAG = "EasyPermissions";
    private static final String DIALOG_TAG = "RationaleDialogFragmentCompat";

    public static boolean hasPermissions(@NonNull Context context, String ... perms) {
        if (Build.VERSION.SDK_INT < 23) {
            Log.w((String)TAG, (String)"hasPermissions: API version < M, returning true by default");
            return true;
        }
        for (String perm : perms) {
            boolean hasPerm;
            boolean bl = hasPerm = ContextCompat.checkSelfPermission((Context)context, (String)perm) == 0;
            if (hasPerm) continue;
            return false;
        }
        return true;
    }

    public static void requestPermissions(@NonNull Object object, @NonNull String rationale, int requestCode, String ... perms) {
        EasyPermissions.requestPermissions(object, rationale, 17039370, 0x1040000, requestCode, perms);
    }

    @SuppressLint(value={"NewApi"})
    public static void requestPermissions(@NonNull Object object, @NonNull String rationale, @StringRes int positiveButton, @StringRes int negativeButton, int requestCode, String ... perms) {
        EasyPermissions.checkCallingObjectSuitability(object);
        boolean shouldShowRationale = false;
        for (String perm : perms) {
            shouldShowRationale = shouldShowRationale || EasyPermissions.shouldShowRequestPermissionRationale(object, perm);
        }
        if (shouldShowRationale) {
            if (EasyPermissions.getSupportFragmentManager(object) != null) {
                EasyPermissions.showRationaleDialogFragmentCompat(EasyPermissions.getSupportFragmentManager(object), rationale, positiveButton, negativeButton, requestCode, perms);
            } else if (EasyPermissions.getFragmentManager(object) != null) {
                EasyPermissions.showRationaleDialogFragment(EasyPermissions.getFragmentManager(object), rationale, positiveButton, negativeButton, requestCode, perms);
            } else {
                EasyPermissions.showRationaleAlertDialog(object, rationale, positiveButton, negativeButton, requestCode, perms);
            }
        } else {
            EasyPermissions.executePermissionsRequest(object, perms, requestCode);
        }
    }

    @RequiresApi(value=11)
    private static void showRationaleDialogFragmentCompat(@NonNull FragmentManager fragmentManager, @NonNull String rationale, @StringRes int positiveButton, @StringRes int negativeButton, int requestCode, String ... perms) {
        RationaleDialogFragmentCompat fragment = RationaleDialogFragmentCompat.newInstance(positiveButton, negativeButton, rationale, requestCode, perms);
        fragment.show(fragmentManager, DIALOG_TAG);
    }

    @RequiresApi(api=11)
    private static void showRationaleDialogFragment(@NonNull android.app.FragmentManager fragmentManager, @NonNull String rationale, @StringRes int positiveButton, @StringRes int negativeButton, int requestCode, String ... perms) {
        RationaleDialogFragment fragment = RationaleDialogFragment.newInstance(positiveButton, negativeButton, rationale, requestCode, perms);
        fragment.show(fragmentManager, DIALOG_TAG);
    }

    private static void showRationaleAlertDialog(final @NonNull Object object, @NonNull String rationale, @StringRes int positiveButton, @StringRes int negativeButton, final int requestCode, final String ... perms) {
        Activity activity = EasyPermissions.getActivity(object);
        if (activity == null) {
            throw new IllegalStateException("Can't show rationale dialog for null Activity");
        }
        new AlertDialog.Builder((Context)activity).setCancelable(false).setMessage((CharSequence)rationale).setPositiveButton(positiveButton, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                EasyPermissions.executePermissionsRequest(object, perms, requestCode);
            }
        }).setNegativeButton(negativeButton, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (object instanceof PermissionCallbacks) {
                    ((PermissionCallbacks)object).onPermissionsDenied(requestCode, Arrays.asList(perms));
                }
            }
        }).create().show();
    }

    public static boolean somePermissionPermanentlyDenied(@NonNull Object object, @NonNull List<String> deniedPermissions) {
        for (String deniedPermission : deniedPermissions) {
            if (!EasyPermissions.permissionPermanentlyDenied(object, deniedPermission)) continue;
            return true;
        }
        return false;
    }

    public static boolean permissionPermanentlyDenied(@NonNull Object object, @NonNull String deniedPermission) {
        return !EasyPermissions.shouldShowRequestPermissionRationale(object, deniedPermission);
    }

    public static void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults, Object ... receivers) {
        ArrayList<String> granted = new ArrayList<String>();
        ArrayList<String> denied = new ArrayList<String>();
        for (int i = 0; i < permissions.length; ++i) {
            String perm = permissions[i];
            if (grantResults[i] == 0) {
                granted.add(perm);
                continue;
            }
            denied.add(perm);
        }
        for (Object object : receivers) {
            if (!granted.isEmpty() && object instanceof PermissionCallbacks) {
                ((PermissionCallbacks)object).onPermissionsGranted(requestCode, granted);
            }
            if (!denied.isEmpty() && object instanceof PermissionCallbacks) {
                ((PermissionCallbacks)object).onPermissionsDenied(requestCode, denied);
            }
            if (granted.isEmpty() || !denied.isEmpty()) continue;
            EasyPermissions.runAnnotatedMethods(object, requestCode);
        }
    }

    @TargetApi(value=23)
    private static boolean shouldShowRequestPermissionRationale(@NonNull Object object, @NonNull String perm) {
        if (object instanceof Activity) {
            return ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)object), (String)perm);
        }
        if (object instanceof android.support.v4.app.Fragment) {
            return ((android.support.v4.app.Fragment)object).shouldShowRequestPermissionRationale(perm);
        }
        if (object instanceof Fragment) {
            return ((Fragment)object).shouldShowRequestPermissionRationale(perm);
        }
        return false;
    }

    @TargetApi(value=23)
    static void executePermissionsRequest(@NonNull Object object, @NonNull String[] perms, int requestCode) {
        EasyPermissions.checkCallingObjectSuitability(object);
        if (object instanceof Activity) {
            ActivityCompat.requestPermissions((Activity)((Activity)object), (String[])perms, (int)requestCode);
        } else if (object instanceof android.support.v4.app.Fragment) {
            ((android.support.v4.app.Fragment)object).requestPermissions(perms, requestCode);
        } else if (object instanceof Fragment) {
            ((Fragment)object).requestPermissions(perms, requestCode);
        }
    }

    @TargetApi(value=11)
    private static Activity getActivity(@NonNull Object object) {
        if (object instanceof Activity) {
            return (Activity)object;
        }
        if (object instanceof android.support.v4.app.Fragment) {
            return ((android.support.v4.app.Fragment)object).getActivity();
        }
        if (object instanceof Fragment) {
            return ((Fragment)object).getActivity();
        }
        return null;
    }

    @Nullable
    @SuppressLint(value={"NewApi"})
    private static FragmentManager getSupportFragmentManager(@NonNull Object object) {
        if (object instanceof FragmentActivity) {
            return ((FragmentActivity)object).getSupportFragmentManager();
        }
        if (object instanceof android.support.v4.app.Fragment) {
            return ((android.support.v4.app.Fragment)object).getChildFragmentManager();
        }
        return null;
    }

    @Nullable
    private static android.app.FragmentManager getFragmentManager(@NonNull Object object) {
        if (object instanceof Activity) {
            if (Build.VERSION.SDK_INT >= 11) {
                return ((Activity)object).getFragmentManager();
            }
        } else if (object instanceof Fragment) {
            if (Build.VERSION.SDK_INT >= 17) {
                return ((Fragment)object).getChildFragmentManager();
            }
            return ((Fragment)object).getFragmentManager();
        }
        return null;
    }

    private static void runAnnotatedMethods(@NonNull Object object, int requestCode) {
        Class<?> clazz = object.getClass();
        if (EasyPermissions.isUsingAndroidAnnotations(object)) {
            clazz = clazz.getSuperclass();
        }
        for (Method method : clazz.getDeclaredMethods()) {
            AfterPermissionGranted ann;
            if (!method.isAnnotationPresent(AfterPermissionGranted.class) || (ann = method.getAnnotation(AfterPermissionGranted.class)).value() != requestCode) continue;
            if (method.getParameterTypes().length > 0) {
                throw new RuntimeException("Cannot execute method " + method.getName() + " because it is non-void method and/or has input parameters.");
            }
            try {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException e) {
                Log.e((String)TAG, (String)"runDefaultMethod:IllegalAccessException", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Log.e((String)TAG, (String)"runDefaultMethod:InvocationTargetException", (Throwable)e);
            }
        }
    }

    private static void checkCallingObjectSuitability(@Nullable Object object) {
        boolean isMinSdkM;
        if (object == null) {
            throw new NullPointerException("Activity or Fragment should not be null");
        }
        boolean isActivity = object instanceof Activity;
        boolean isSupportFragment = object instanceof android.support.v4.app.Fragment;
        boolean isAppFragment = object instanceof Fragment;
        boolean bl = isMinSdkM = Build.VERSION.SDK_INT >= 23;
        if (!(isSupportFragment || isActivity || isAppFragment && isMinSdkM)) {
            if (isAppFragment) {
                throw new IllegalArgumentException("Target SDK needs to be greater than 23 if caller is android.app.Fragment");
            }
            throw new IllegalArgumentException("Caller must be an Activity or a Fragment.");
        }
    }

    private static boolean isUsingAndroidAnnotations(@NonNull Object object) {
        if (!object.getClass().getSimpleName().endsWith("_")) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName("org.androidannotations.api.view.HasViews");
            return clazz.isInstance(object);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static interface PermissionCallbacks
    extends ActivityCompat.OnRequestPermissionsResultCallback {
        public void onPermissionsGranted(int var1, List<String> var2);

        public void onPermissionsDenied(int var1, List<String> var2);
    }
}

