/*
 * Decompiled with CFR 0.152.
 */
package pub.devrel.easypermissions;

import android.content.DialogInterface;
import android.support.annotation.RequiresApi;
import java.util.Arrays;
import pub.devrel.easypermissions.EasyPermissions;
import pub.devrel.easypermissions.RationaleDialogConfig;
import pub.devrel.easypermissions.RationaleDialogFragment;
import pub.devrel.easypermissions.RationaleDialogFragmentCompat;

class RationaleDialogClickListener
implements DialogInterface.OnClickListener {
    private Object mHost;
    private RationaleDialogConfig mConfig;
    private EasyPermissions.PermissionCallbacks mCallbacks;

    RationaleDialogClickListener(RationaleDialogFragmentCompat compatDialogFragment, RationaleDialogConfig config, EasyPermissions.PermissionCallbacks callbacks) {
        this.mHost = compatDialogFragment.getParentFragment() != null ? compatDialogFragment.getParentFragment() : compatDialogFragment.getActivity();
        this.mConfig = config;
        this.mCallbacks = callbacks;
    }

    @RequiresApi(api=11)
    RationaleDialogClickListener(RationaleDialogFragment dialogFragment, RationaleDialogConfig config, EasyPermissions.PermissionCallbacks callbacks) {
        this.mHost = dialogFragment.getActivity();
        this.mConfig = config;
        this.mCallbacks = callbacks;
    }

    public void onClick(DialogInterface dialog, int which) {
        if (which == -1) {
            EasyPermissions.executePermissionsRequest(this.mHost, this.mConfig.permissions, this.mConfig.requestCode);
        } else {
            this.notifyPermissionDenied();
        }
    }

    private void notifyPermissionDenied() {
        if (this.mCallbacks != null) {
            this.mCallbacks.onPermissionsDenied(this.mConfig.requestCode, Arrays.asList(this.mConfig.permissions));
        }
    }
}

