/*
 * Decompiled with CFR 0.152.
 */
package ru.alexbykov.nopaginate.paginate;

import android.support.annotation.NonNull;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import ru.alexbykov.nopaginate.callback.OnAdapterChangeListener;
import ru.alexbykov.nopaginate.callback.OnLoadMoreListener;
import ru.alexbykov.nopaginate.callback.OnRepeatListener;
import ru.alexbykov.nopaginate.item.DefaultGridLayoutItem;
import ru.alexbykov.nopaginate.item.ErrorItem;
import ru.alexbykov.nopaginate.item.LoadingItem;
import ru.alexbykov.nopaginate.paginate.NoPaginateBuilder;
import ru.alexbykov.nopaginate.paginate.PaginateStatus;
import ru.alexbykov.nopaginate.paginate.ScrollUtils;
import ru.alexbykov.nopaginate.paginate.WrapperAdapter;
import ru.alexbykov.nopaginate.paginate.WrapperAdapterObserver;
import ru.alexbykov.nopaginate.paginate.grid.WrapperSpanSizeLookup;

public final class NoPaginate
implements OnAdapterChangeListener,
OnRepeatListener {
    private final int loadingTriggerThreshold;
    private final RecyclerView recyclerView;
    private final OnLoadMoreListener loadMoreListener;
    private final LoadingItem loadingItem;
    private final ErrorItem errorItem;
    private WrapperAdapter wrapperAdapter;
    private WrapperAdapterObserver wrapperAdapterObserver;
    private RecyclerView.Adapter userAdapter;
    private WrapperSpanSizeLookup wrapperSpanSizeLookup;
    private boolean isError;
    private boolean isLoading;
    private boolean isLoadedAllItems;
    private final RecyclerView.OnScrollListener scrollListener = new RecyclerView.OnScrollListener(){

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            NoPaginate.this.checkScroll();
        }
    };

    NoPaginate(RecyclerView recyclerView, OnLoadMoreListener loadMoreListener, int loadingTriggerThreshold, LoadingItem loadingItem, ErrorItem errorItem) {
        this.recyclerView = recyclerView;
        this.loadMoreListener = loadMoreListener;
        this.loadingTriggerThreshold = loadingTriggerThreshold;
        this.loadingItem = loadingItem;
        this.errorItem = errorItem;
        this.setupWrapper();
        this.setupScrollListener();
    }

    public static NoPaginateBuilder with(@NonNull RecyclerView recyclerView) {
        return new NoPaginateBuilder(recyclerView);
    }

    private void setupWrapper() {
        this.userAdapter = this.recyclerView.getAdapter();
        this.wrapperAdapter = new WrapperAdapter(this.userAdapter, this.loadingItem, this.errorItem);
        this.wrapperAdapterObserver = new WrapperAdapterObserver(this, this.wrapperAdapter);
        this.userAdapter.registerAdapterDataObserver((RecyclerView.AdapterDataObserver)this.wrapperAdapterObserver);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.wrapperAdapter);
        this.wrapperAdapter.setRepeatListener(this);
        this.checkGridLayoutManager();
    }

    private void checkGridLayoutManager() {
        if (this.recyclerView.getLayoutManager() instanceof GridLayoutManager) {
            DefaultGridLayoutItem item = new DefaultGridLayoutItem(this.recyclerView.getLayoutManager());
            this.wrapperSpanSizeLookup = new WrapperSpanSizeLookup(((GridLayoutManager)this.recyclerView.getLayoutManager()).getSpanSizeLookup(), item, this.wrapperAdapter);
            ((GridLayoutManager)this.recyclerView.getLayoutManager()).setSpanSizeLookup((GridLayoutManager.SpanSizeLookup)this.wrapperSpanSizeLookup);
        }
    }

    private void setupScrollListener() {
        this.recyclerView.addOnScrollListener(this.scrollListener);
    }

    private void checkAdapterState() {
        if (this.isCanLoadMore() && this.loadMoreListener != null) {
            this.loadMoreListener.onLoadMore();
        }
    }

    private boolean isCanLoadMore() {
        return !this.isLoading && !this.isError && !this.isLoadedAllItems;
    }

    @Override
    public void onAdapterChange() {
        this.recyclerView.post(new Runnable(){

            @Override
            public void run() {
                PaginateStatus status = PaginateStatus.getStatus(NoPaginate.this.isLoadedAllItems, NoPaginate.this.isError);
                NoPaginate.this.wrapperAdapter.stateChanged(status);
                NoPaginate.this.checkScroll();
            }
        });
    }

    private void checkScroll() {
        if (ScrollUtils.isOnBottom(this.recyclerView, this.loadingTriggerThreshold)) {
            this.checkAdapterState();
        }
    }

    public void showError(boolean isShowError) {
        if (isShowError) {
            this.isError = true;
            this.wrapperAdapter.stateChanged(PaginateStatus.ERROR);
            ScrollUtils.fullScrollToBottom(this.recyclerView, this.wrapperAdapter);
        } else {
            this.isError = false;
        }
    }

    public void showLoading(boolean show) {
        if (show) {
            this.isLoading = true;
            this.wrapperAdapter.stateChanged(PaginateStatus.LOADING);
        } else {
            this.isLoading = false;
        }
    }

    public void setNoMoreItems(boolean isNoMoreItems) {
        if (isNoMoreItems) {
            this.isLoadedAllItems = true;
            this.wrapperAdapter.stateChanged(PaginateStatus.NO_MORE_ITEMS);
        } else {
            this.isLoadedAllItems = false;
        }
    }

    @Override
    public void onClickRepeat() {
        this.showError(false);
        this.checkScroll();
    }

    public void unbind() {
        this.recyclerView.removeOnScrollListener(this.scrollListener);
        if (this.recyclerView.getLayoutManager() instanceof LinearLayoutManager) {
            this.wrapperAdapter.unbind();
            this.userAdapter.unregisterAdapterDataObserver((RecyclerView.AdapterDataObserver)this.wrapperAdapterObserver);
            this.recyclerView.setAdapter(this.userAdapter);
        } else if (this.recyclerView.getLayoutManager() instanceof GridLayoutManager && this.wrapperSpanSizeLookup != null) {
            GridLayoutManager.SpanSizeLookup spanSizeLookup = this.wrapperSpanSizeLookup.getWrappedSpanSizeLookup();
            ((GridLayoutManager)this.recyclerView.getLayoutManager()).setSpanSizeLookup(spanSizeLookup);
        }
    }
}

