/*
 * Decompiled with CFR 0.152.
 */
package ru.alexbykov.nopaginate.paginate;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import ru.alexbykov.nopaginate.callback.OnLoadMoreListener;
import ru.alexbykov.nopaginate.item.ErrorItem;
import ru.alexbykov.nopaginate.item.LoadingItem;
import ru.alexbykov.nopaginate.paginate.NoPaginate;

public final class NoPaginateBuilder {
    private RecyclerView recyclerView;
    private OnLoadMoreListener loadMoreListener;
    private LoadingItem loadingItem;
    private ErrorItem errorItem;
    private int loadingTriggerThreshold = 0;

    NoPaginateBuilder(@NonNull RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
    }

    public NoPaginateBuilder setOnLoadMoreListener(@NonNull OnLoadMoreListener loadMoreListener) {
        this.loadMoreListener = loadMoreListener;
        return this;
    }

    public NoPaginateBuilder setLoadingTriggerThreshold(@IntRange(from=0L) int loadingTriggerThreshold) {
        this.loadingTriggerThreshold = loadingTriggerThreshold;
        return this;
    }

    public NoPaginateBuilder setCustomLoadingItem(@NonNull LoadingItem loadingItem) {
        this.loadingItem = loadingItem;
        return this;
    }

    public NoPaginateBuilder setCustomErrorItem(@NonNull ErrorItem errorItem) {
        this.errorItem = errorItem;
        return this;
    }

    public NoPaginate build() {
        if (this.loadingItem == null) {
            this.loadingItem = LoadingItem.DEFAULT;
        }
        if (this.errorItem == null) {
            this.errorItem = ErrorItem.DEFAULT;
        }
        return new NoPaginate(this.recyclerView, this.loadMoreListener, this.loadingTriggerThreshold, this.loadingItem, this.errorItem);
    }
}

