/*
 * Decompiled with CFR 0.152.
 */
package ru.alexbykov.nopaginate.paginate;

import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;

final class ScrollUtils {
    private ScrollUtils() {
    }

    static boolean isOnBottom(@NonNull RecyclerView recyclerView, int loadingTriggerThreshold) {
        int firstVisibleItemPosition;
        int visibleItemCount = recyclerView.getChildCount();
        int totalItemCount = recyclerView.getLayoutManager().getItemCount();
        return totalItemCount - visibleItemCount <= (firstVisibleItemPosition = ScrollUtils.getFirstVisibleItemPositionByLayoutManager(recyclerView.getLayoutManager())) + loadingTriggerThreshold || totalItemCount == 0;
    }

    private static int getFirstVisibleItemPositionByLayoutManager(@NonNull RecyclerView.LayoutManager layoutManager) {
        int firstVisibleItemPosition;
        if (layoutManager instanceof LinearLayoutManager) {
            firstVisibleItemPosition = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
        } else if (layoutManager instanceof StaggeredGridLayoutManager) {
            firstVisibleItemPosition = layoutManager.getChildCount() > 0 ? ((StaggeredGridLayoutManager)layoutManager).findFirstVisibleItemPositions(null)[0] : 0;
        } else {
            throw new IllegalStateException("LayoutManager needs to subclass LinearLayoutManager or StaggeredGridLayoutManager");
        }
        return firstVisibleItemPosition;
    }

    static void fullScrollToBottom(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.Adapter adapter) {
        recyclerView.getLayoutManager().smoothScrollToPosition(recyclerView, null, adapter.getItemCount() - 1);
    }
}

