/*
 * Decompiled with CFR 0.152.
 */
package ru.alexbykov.nopaginate.paginate;

import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import ru.alexbykov.nopaginate.callback.OnRepeatListener;
import ru.alexbykov.nopaginate.item.ErrorItem;
import ru.alexbykov.nopaginate.item.LoadingItem;
import ru.alexbykov.nopaginate.paginate.PaginateStatus;

public final class WrapperAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int ITEM_VIEW_TYPE_LOADING = 46699933;
    private static final int ITEM_VIEW_TYPE_ERROR = 46699932;
    private RecyclerView.Adapter userAdapter;
    private LoadingItem loadingItem;
    private ErrorItem errorItem;
    private PaginateStatus paginateStatus = PaginateStatus.LOADING;
    private OnRepeatListener repeatListener;

    WrapperAdapter(RecyclerView.Adapter userAdapter, LoadingItem loadingItem, ErrorItem errorItem) {
        this.userAdapter = userAdapter;
        this.loadingItem = loadingItem;
        this.errorItem = errorItem;
    }

    public int getItemViewType(int position) {
        if (this.isLoadingItem(position)) {
            return 46699933;
        }
        if (this.isErrorItem(position)) {
            return 46699932;
        }
        return this.userAdapter.getItemViewType(position);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 46699933) {
            return this.loadingItem.onCreateViewHolder(parent, viewType);
        }
        if (viewType == 46699932) {
            return this.errorItem.onCreateViewHolder(parent, viewType);
        }
        return this.userAdapter.onCreateViewHolder(parent, viewType);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (this.isLoadingItem(position)) {
            this.loadingItem.onBindViewHolder(holder, position);
        } else if (this.isErrorItem(position)) {
            this.errorItem.onBindViewHolder(holder, position, this.repeatListener);
        } else {
            this.userAdapter.onBindViewHolder(holder, position);
        }
    }

    public boolean isErrorItem(int position) {
        return this.paginateStatus == PaginateStatus.ERROR && position == this.getErrorOrLoadingItemPosition();
    }

    public boolean isLoadingItem(int position) {
        return this.paginateStatus == PaginateStatus.LOADING && position == this.getErrorOrLoadingItemPosition();
    }

    private int getErrorOrLoadingItemPosition() {
        return this.isErrorOrLoading() ? this.getItemCount() - 1 : -1;
    }

    private boolean isErrorOrLoading() {
        return this.paginateStatus == PaginateStatus.LOADING || this.paginateStatus == PaginateStatus.ERROR;
    }

    public int getItemCount() {
        return this.isErrorOrLoading() ? this.userAdapter.getItemCount() + 1 : this.userAdapter.getItemCount();
    }

    void stateChanged(PaginateStatus status) {
        if (this.paginateStatus != status) {
            this.paginateStatus = status;
            this.notifyDataSetChanged();
        }
    }

    public void setHasStableIds(boolean hasStableIds) {
        super.setHasStableIds(hasStableIds);
        this.userAdapter.setHasStableIds(hasStableIds);
    }

    void setRepeatListener(OnRepeatListener repeatListener) {
        this.repeatListener = repeatListener;
    }

    void unbind() {
        this.repeatListener = null;
    }
}

