/*
 * Decompiled with CFR 0.152.
 */
package ru.alexbykov.nopaginate.paginate;

import android.support.v7.widget.RecyclerView;
import ru.alexbykov.nopaginate.callback.OnAdapterChangeListener;
import ru.alexbykov.nopaginate.paginate.WrapperAdapter;

final class WrapperAdapterObserver
extends RecyclerView.AdapterDataObserver {
    private WrapperAdapter wrapperAdapter;
    private OnAdapterChangeListener adapterChangeListener;

    WrapperAdapterObserver(OnAdapterChangeListener adapterChangeListener, WrapperAdapter wrapperAdapter) {
        this.wrapperAdapter = wrapperAdapter;
        this.adapterChangeListener = adapterChangeListener;
    }

    public void onItemRangeChanged(int positionStart, int itemCount) {
        this.wrapperAdapter.notifyItemRangeChanged(positionStart, itemCount);
        this.adapterChangeListener.onAdapterChange();
    }

    public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
        this.wrapperAdapter.notifyItemRangeChanged(positionStart, itemCount, payload);
        this.adapterChangeListener.onAdapterChange();
    }

    public void onItemRangeInserted(int positionStart, int itemCount) {
        this.wrapperAdapter.notifyItemRangeChanged(positionStart, itemCount);
        this.adapterChangeListener.onAdapterChange();
    }

    public void onItemRangeRemoved(int positionStart, int itemCount) {
        this.wrapperAdapter.notifyItemRangeRemoved(positionStart, itemCount);
        this.adapterChangeListener.onAdapterChange();
    }

    public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
        this.wrapperAdapter.notifyItemMoved(fromPosition, toPosition);
        this.adapterChangeListener.onAdapterChange();
    }

    public void onChanged() {
        this.wrapperAdapter.notifyDataSetChanged();
        this.adapterChangeListener.onAdapterChange();
    }
}

