/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.tpoms.log.dao;

import com.xdja.cssp.tpoms.log.entity.SystemLog;
import com.xdja.cssp.tpoms.log.util.DateQueryBean;
import com.xdja.platform.datacenter.jpa.dao.BaseJpaDao;
import com.xdja.platform.datacenter.jpa.page.Pagination;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class SystemLogDao
extends BaseJpaDao<SystemLog, Long> {
    public Pagination<SystemLog> querySystemLogs(SystemLog syslog, Integer pageNo, Integer pageSize, String sortName, String sortType, DateQueryBean queryBean) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT log.n_id as id ,log.n_type as logType, ").append("log.n_time  as logTime ,user.c_name as userName , log.c_content as logContent FROM t_log ").append("log  LEFT JOIN  t_user user  ON  log.n_user_id = user.n_id  where 1=1 ");
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        this.fmSql(syslog, queryBean, sqlBuilder, sqlParameterSource);
        if (StringUtils.isNotEmpty((CharSequence)sortName) && StringUtils.isNotEmpty((CharSequence)sortType)) {
            sqlBuilder.append("ORDER BY " + sortName + " " + sortType);
        } else {
            sqlBuilder.append("ORDER BY log.n_time DESC ");
        }
        return this.queryForPage(sqlBuilder.toString(), pageSize, pageNo, sqlParameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(SystemLog.class));
    }

    public List<SystemLog> querySystemLogs(SystemLog syslog, DateQueryBean queryBean) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT log.n_id as id ,log.n_type as logType, ").append("log.n_time  as logTime ,user.c_name as userName , log.c_content as logContent FROM t_log ").append("log  LEFT JOIN  t_user user  ON  log.n_user_id = user.n_id  where 1=1 ");
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        this.fmSql(syslog, queryBean, sqlBuilder, sqlParameterSource);
        sqlBuilder.append("ORDER BY log.n_time DESC ");
        return this.queryForList(sqlBuilder.toString(), (SqlParameterSource)sqlParameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(SystemLog.class));
    }

    private void fmSql(SystemLog syslog, DateQueryBean queryBean, StringBuilder sqlBuilder, MapSqlParameterSource sqlParameterSource) {
        if (null != syslog) {
            if (null != syslog.getLogType()) {
                sqlBuilder.append("AND  log.n_type = :type ");
                sqlParameterSource.addValue("type", (Object)syslog.getLogType());
            }
            if (StringUtils.isNotBlank((CharSequence)syslog.getUserName())) {
                sqlBuilder.append("AND log.c_user = :username ");
                sqlParameterSource.addValue("username", (Object)syslog.getUserName());
            }
            sqlBuilder.append("AND  log.n_custom_id = :customId ");
            sqlParameterSource.addValue("customId", (Object)syslog.getCustomId());
        }
        if (null != queryBean) {
            if (null != queryBean.getStart()) {
                sqlBuilder.append("AND log.n_time >= :startTime ");
                sqlParameterSource.addValue("startTime", (Object)queryBean.getStart());
            }
            if (null != queryBean.getEnd()) {
                sqlBuilder.append("AND log.n_time <= :endTime ");
                sqlParameterSource.addValue("endTime", (Object)queryBean.getEnd());
            }
        }
    }
}

