/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.tpoms.system.business.impl;

import com.xdja.cssp.tpoms.system.business.IRoleBusiness;
import com.xdja.cssp.tpoms.system.dao.TFunctionDao;
import com.xdja.cssp.tpoms.system.dao.TRoleDao;
import com.xdja.cssp.tpoms.system.dao.TRoleFuncDao;
import com.xdja.cssp.tpoms.system.dao.TUserRoleDao;
import com.xdja.cssp.tpoms.system.entity.TFunction;
import com.xdja.cssp.tpoms.system.entity.TRole;
import com.xdja.cssp.tpoms.system.entity.TRoleFunc;
import com.xdja.cssp.tpoms.system.entity.TUserRole;
import com.xdja.platform.datacenter.jpa.business.BaseBusiness;
import com.xdja.platform.datacenter.jpa.page.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RoleBusinessImpl
extends BaseBusiness
implements IRoleBusiness {
    @Autowired
    private TRoleDao roleDao;
    @Autowired
    private TRoleFuncDao roleFuncDao;
    @Autowired
    private TUserRoleDao userRoleDao;
    @Autowired
    private TFunctionDao functionDao;

    @Override
    public void saveRole(TRole role, String funcIds) {
        String[] funcIdsArr = funcIds.split(",");
        Object[] roleFuncArray = new TRoleFunc[funcIdsArr.length];
        if (null == role.getId()) {
            role.setType(TRole.ENUM_ROLE_TYPE.consumerRole.value);
        }
        role.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        this.roleDao.save(role);
        for (int index = 0; index < funcIdsArr.length; ++index) {
            TRoleFunc roleFunc = new TRoleFunc();
            roleFunc.setRoleId(role.getId());
            roleFunc.setFuncId(Long.valueOf(Long.parseLong(funcIdsArr[index])));
            roleFuncArray[index] = roleFunc;
        }
        this.roleFuncDao.delRoleFuncByRoleId(role.getId());
        this.roleFuncDao.save(roleFuncArray);
    }

    @Override
    public TRole getRoleById(Long roleId) {
        return (TRole)this.roleDao.find(roleId);
    }

    @Override
    public boolean deleteRoleById(Long roleId) {
        Integer userRoleCount = this.userRoleDao.getUserCountByRoleId(roleId);
        if (userRoleCount == 0) {
            this.roleDao.removeById(roleId);
            this.roleFuncDao.delRoleFuncByRoleId(roleId);
            return true;
        }
        return false;
    }

    @Override
    public Pagination<TRole> queryAllRoles(Long customId, String searchKey, Integer pageNo, Integer pageSize) {
        return this.roleDao.queryAllRoles(customId, searchKey, pageNo, pageSize);
    }

    @Override
    public List<TRole> queryAllRoles(Long customId) {
        return this.roleDao.queryAllRoles(customId);
    }

    @Override
    public List<TUserRole> queryUserRoleListByUserId(Long userId) {
        return this.userRoleDao.queryUserRoleListByUserId(userId);
    }

    @Override
    public List<TRoleFunc> queryRoleFuncByRoleId(Long roleId) {
        return this.roleFuncDao.queryRoleFuncByRoleId(roleId);
    }

    @Override
    public List<TFunction> queryAllFunctions() {
        return this.functionDao.queryAllFunctions();
    }

    @Override
    public boolean isRoleNameExist(Long roleId, String name, Long customId) {
        return this.roleDao.isRoleNameExist(roleId, name, customId);
    }
}

