/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.tpoms.system.business.impl;

import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import com.xdja.cssp.oms.core.cons.UserType;
import com.xdja.cssp.tpoms.system.business.IUserBusiness;
import com.xdja.cssp.tpoms.system.dao.TUserCertDao;
import com.xdja.cssp.tpoms.system.dao.TUserDao;
import com.xdja.cssp.tpoms.system.dao.TUserRoleDao;
import com.xdja.cssp.tpoms.system.entity.TUser;
import com.xdja.cssp.tpoms.system.entity.TUserCert;
import com.xdja.cssp.tpoms.system.entity.TUserRole;
import com.xdja.platform.datacenter.jpa.business.BaseBusiness;
import com.xdja.platform.datacenter.jpa.page.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserBusinessImpl
extends BaseBusiness
implements IUserBusiness {
    @Autowired
    private TUserDao userDao;
    @Autowired
    private TUserRoleDao userRoleDao;
    @Autowired
    private TUserCertDao userCertDao;

    @Override
    public TUser getUserByUserName(String username) {
        Search search = new Search(TUser.class);
        search.addFilterEqual("username", (Object)username);
        return (TUser)this.userDao.searchUnique((ISearch)search);
    }

    @Override
    public boolean cardIdIsExist(String username, String cardId) {
        return this.userDao.queryCardIsBind(username, cardId) > 0;
    }

    @Override
    public Pagination<TUser> queryAllUsers(TUser currUser, String searchKey, Integer pageNo, Integer pageSize) {
        return this.userDao.queryAllUsers(currUser, searchKey, pageNo, pageSize);
    }

    @Override
    public List<TUser> queryAllUsers(Long customId) {
        return this.userDao.queryAllUsers(customId);
    }

    @Override
    public boolean isNameExist(String username, Long userId, Long customId) {
        return this.userDao.isNameExist(username, userId, customId);
    }

    @Override
    public void saveUser(TUser user, Long[] roleId) {
        if (null == user.getId()) {
            user.setType(Integer.valueOf(UserType.consumerUser.getValue()));
            user.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        }
        this.userDao.save(user);
        this.userRoleDao.removeUserRoleByUserId(user.getId());
        if (null != roleId) {
            Object[] userRoles = new TUserRole[roleId.length];
            for (int i = 0; i < roleId.length; ++i) {
                TUserRole userRole = new TUserRole();
                userRole.setUserId(user.getId());
                userRole.setRoleId(roleId[i]);
                userRoles[i] = userRole;
            }
            this.userRoleDao.save(userRoles);
        }
    }

    @Override
    public TUser findById(Long userId) {
        return (TUser)this.userDao.find(userId);
    }

    @Override
    public void updateUserStatus(Long userId, Integer status) {
        TUser user = (TUser)this.userDao.find(userId);
        user.setStatus(status);
    }

    @Override
    public Integer queryUserCertByCardId(String cardId) {
        return this.userCertDao.queryUserCertByCardId(cardId);
    }

    @Override
    public Pagination<TUserCert> queryAllUserCert(Long userId, int pageNo, int pageSize) {
        return this.userCertDao.queryAllUserCert(userId, pageNo, pageSize);
    }

    @Override
    public void deleteCard(Long userCertId) {
        this.userCertDao.removeById(userCertId);
    }

    @Override
    public void saveUserCert(TUserCert userCert) {
        this.userCertDao.save(userCert);
    }
}

