/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.tpoms.system.dao;

import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import com.xdja.cssp.tpoms.system.entity.TRole;
import com.xdja.platform.datacenter.jpa.dao.BaseJpaDao;
import com.xdja.platform.datacenter.jpa.page.Pagination;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class TRoleDao
extends BaseJpaDao<TRole, Long> {
    public Pagination<TRole> queryAllRoles(Long customId, String searchKey, Integer pageNo, Integer pageSize) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("SELECT n_id AS id, c_name AS name, c_note AS note, c_create_user AS createUser, ").append(" n_create_time AS createTime, n_type AS type, n_custom_id AS customId  FROM t_role WHERE 1 = 1 ");
        if (StringUtils.isNotBlank((CharSequence)searchKey)) {
            sqlBuilder.append("AND (c_name like :name ESCAPE '/' ");
            sqlBuilder.append(" OR c_create_user like :createUser ESCAPE '/' ) ");
            searchKey = searchKey.replaceAll("%", "/%");
            searchKey = searchKey.replaceAll("_", "/_");
            sqlParameterSource.addValue("name", (Object)("%" + searchKey + "%"));
            sqlParameterSource.addValue("createUser", (Object)("%" + searchKey + "%"));
        }
        sqlBuilder.append(" AND n_type = :type AND n_custom_id = :customId");
        sqlParameterSource.addValue("type", (Object)TRole.ENUM_ROLE_TYPE.consumerRole.value);
        sqlParameterSource.addValue("customId", (Object)customId);
        return this.queryForPage(sqlBuilder.toString(), pageSize, pageNo, sqlParameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(TRole.class));
    }

    public List<TRole> queryAllRoles(Long customId) {
        Search search = new Search(TRole.class);
        search.addFilterEqual("customId", (Object)customId);
        return this.search((ISearch)search);
    }

    public boolean isRoleNameExist(Long roleId, String name, Long customId) {
        StringBuilder sql = new StringBuilder();
        MapSqlParameterSource paramSource = new MapSqlParameterSource();
        sql.append("SELECT COUNT(1) FROM t_role WHERE 1 = 1 ");
        sql.append(" AND n_custom_id = :customId ");
        paramSource.addValue("customId", (Object)customId);
        if (null != roleId) {
            sql.append(" AND n_id != :roleId");
            paramSource.addValue("roleId", (Object)roleId);
        }
        sql.append(" AND c_name = :name");
        paramSource.addValue("name", (Object)name);
        return this.queryForInt(sql.toString(), (SqlParameterSource)paramSource) > 0;
    }
}

