/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.tpoms.system.dao;

import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import com.xdja.cssp.oms.core.cons.UserType;
import com.xdja.cssp.tpoms.system.entity.TUser;
import com.xdja.platform.datacenter.jpa.dao.BaseJpaDao;
import com.xdja.platform.datacenter.jpa.page.Pagination;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class TUserDao
extends BaseJpaDao<TUser, Long> {
    public int queryCardIsBind(String uName, String cardId) {
        StringBuilder sql = new StringBuilder("SELECT count(0) ");
        sql.append(" FROM t_user_cert cert");
        sql.append(" LEFT JOIN t_user user ON cert.n_user_id = user.n_id");
        sql.append(" WHERE user.c_user_name = :userName AND cert.c_card_id = :cardId");
        MapSqlParameterSource paramSource = new MapSqlParameterSource();
        paramSource.addValue("userName", (Object)uName);
        paramSource.addValue("cardId", (Object)cardId);
        return this.queryForInt(sql.toString(), (SqlParameterSource)paramSource);
    }

    public Pagination<TUser> queryAllUsers(TUser currUser, String searchKey, Integer pageNo, Integer pageSize) {
        StringBuilder sql = new StringBuilder();
        MapSqlParameterSource paramSource = new MapSqlParameterSource();
        sql.append("SELECT n_id AS id, c_name AS name, c_user_name AS username, c_mobile AS mobile, c_email AS email, ").append("n_create_time AS createTime, n_type AS type, n_status AS status, n_custom_id AS customId ").append(" FROM t_user WHERE 1 = 1 ");
        sql.append(" AND n_custom_id = :customId ");
        paramSource.addValue("customId", (Object)currUser.getCustomId());
        if (currUser.getType().intValue() == UserType.consumerUser.getValue()) {
            sql.append(" AND n_type = :type ");
            paramSource.addValue("type", (Object)UserType.consumerUser.getValue());
        }
        if (StringUtils.isNotBlank((CharSequence)searchKey)) {
            sql.append("AND ( c_name like :name ESCAPE '/' ");
            sql.append("OR c_user_name like :username ESCAPE '/' ");
            sql.append("OR c_mobile like :mobile ESCAPE '/' ");
            sql.append("OR c_email like :email ESCAPE '/') ");
            searchKey = searchKey.replaceAll("%", "/%");
            searchKey = searchKey.replaceAll("_", "/_");
            paramSource.addValue("name", (Object)("%" + searchKey + "%"));
            paramSource.addValue("username", (Object)("%" + searchKey + "%"));
            paramSource.addValue("mobile", (Object)("%" + searchKey + "%"));
            paramSource.addValue("email", (Object)("%" + searchKey + "%"));
        }
        return this.queryForPage(sql.toString(), pageSize, pageNo, paramSource, (RowMapper)BeanPropertyRowMapper.newInstance(TUser.class));
    }

    public List<TUser> queryAllUsers(Long customId) {
        Search search = new Search(TUser.class);
        search.addFilterEqual("customId", (Object)customId);
        return this.search((ISearch)search);
    }

    public boolean isNameExist(String username, Long userId, Long customId) {
        StringBuilder sql = new StringBuilder();
        MapSqlParameterSource paramSource = new MapSqlParameterSource();
        sql.append("SELECT COUNT(1) FROM t_user WHERE 1 = 1 ");
        sql.append(" AND n_custom_id = :customId ");
        paramSource.addValue("customId", (Object)customId);
        if (null != userId) {
            sql.append(" AND n_id != :userId");
            paramSource.addValue("userId", (Object)userId);
        }
        sql.append(" AND c_user_name = :username");
        paramSource.addValue("username", (Object)username);
        return this.queryForInt(sql.toString(), (SqlParameterSource)paramSource) > 0;
    }
}

