/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.tpoms.system.service.impl;

import com.xdja.cssp.tpoms.system.business.IRoleBusiness;
import com.xdja.cssp.tpoms.system.entity.TFunction;
import com.xdja.cssp.tpoms.system.entity.TRole;
import com.xdja.cssp.tpoms.system.entity.TRoleFunc;
import com.xdja.cssp.tpoms.system.entity.TUser;
import com.xdja.cssp.tpoms.system.entity.TUserRole;
import com.xdja.cssp.tpoms.system.service.IRoleService;
import com.xdja.platform.rpc.proxy.PagingConverter;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class RoleServiceImpl
implements IRoleService {
    @Resource
    private IRoleBusiness roleBusiness;

    public void saveRole(TRole role, String funcIds) {
        if (null != role) {
            if (!StringUtils.isNotBlank((CharSequence)funcIds)) {
                throw new IllegalArgumentException("\u4e3a\u89d2\u8272\u7ed1\u5b9a\u7684\u529f\u80fd\u6743\u9650\u4e3a\u7a7a");
            }
        } else {
            throw new IllegalArgumentException("\u89d2\u8272\u4fe1\u606f\u4e3a\u7a7a");
        }
        this.roleBusiness.saveRole(role, funcIds);
    }

    public TRole getRoleById(Long roleId) {
        return this.roleBusiness.getRoleById(roleId);
    }

    public boolean deleteRoleById(Long roleId) {
        if (null != roleId) {
            return this.roleBusiness.deleteRoleById(roleId);
        }
        throw new IllegalArgumentException("\u89d2\u8272id\u4e3a\u7a7a");
    }

    public LitePaging<TRole> queryAllRoles(Long customId, String searchKey, Integer pageNo, Integer pageSize) {
        return PagingConverter.convert(this.roleBusiness.queryAllRoles(customId, searchKey, pageNo, pageSize));
    }

    public List<TRole> queryAllRoles(Long customId) {
        return this.roleBusiness.queryAllRoles(customId);
    }

    public List<TRole> queryListRolesOrCheck(TUser user) {
        List<TRole> roleList;
        ArrayList<Long> roleIdList = new ArrayList<Long>();
        ArrayList<TRole> roleReturnList = new ArrayList<TRole>();
        List<TUserRole> userRoleList = this.roleBusiness.queryUserRoleListByUserId(user.getId());
        if (!userRoleList.isEmpty()) {
            for (TUserRole userRole : userRoleList) {
                roleIdList.add(userRole.getRoleId());
            }
        }
        if (!(roleList = this.roleBusiness.queryAllRoles(user.getCustomId())).isEmpty()) {
            for (TRole role : roleList) {
                if (roleIdList.contains(role.getId())) {
                    role.setCheckFlag(true);
                }
                roleReturnList.add(role);
            }
        }
        return roleReturnList;
    }

    public List<Map<String, Object>> queryAllFunctions(Long roleId) {
        List<TRoleFunc> roleFunctionList;
        ArrayList<Long> roleFuncIds = new ArrayList<Long>();
        if (null != roleId && !(roleFunctionList = this.roleBusiness.queryRoleFuncByRoleId(roleId)).isEmpty()) {
            for (TRoleFunc roleFunction : roleFunctionList) {
                roleFuncIds.add(roleFunction.getFuncId());
            }
        }
        List<TFunction> listFunction = this.roleBusiness.queryAllFunctions();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (TFunction func : listFunction) {
            HashMap<String, Object> funcMap = new HashMap<String, Object>();
            funcMap.put("id", func.getId());
            funcMap.put("pId", func.getParentId());
            funcMap.put("name", func.getName());
            funcMap.put("checked", roleFuncIds.contains(func.getId()));
            result.add(funcMap);
        }
        return result;
    }

    public boolean isRoleNameExist(Long roleId, String name, Long customId) {
        return this.roleBusiness.isRoleNameExist(roleId, name, customId);
    }
}

