/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.tpoms.system.service.impl;

import com.xdja.cssp.oms.core.cons.UserStatus;
import com.xdja.cssp.tpoms.system.business.IUserBusiness;
import com.xdja.cssp.tpoms.system.entity.TUser;
import com.xdja.cssp.tpoms.system.entity.TUserCert;
import com.xdja.cssp.tpoms.system.service.IUserService;
import com.xdja.cssp.tpoms.system.util.CertUtil;
import com.xdja.platform.rpc.proxy.PagingConverter;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class UserServiceImpl
implements IUserService {
    @Resource
    private IUserBusiness userBusiness;

    public TUser getUserByUserName(String username) {
        return this.userBusiness.getUserByUserName(username);
    }

    public boolean cardIdIsExist(String username, String cardId) {
        return this.userBusiness.cardIdIsExist(username, cardId);
    }

    public LitePaging<TUser> queryAllUsers(TUser currUser, String searchKey, Integer pageNo, Integer pageSize) {
        return PagingConverter.convert(this.userBusiness.queryAllUsers(currUser, searchKey, pageNo, pageSize));
    }

    public List<TUser> queryAllUsers(Long customId) {
        return this.userBusiness.queryAllUsers(customId);
    }

    public boolean isNameExist(String username, Long userId, Long customId) {
        return this.userBusiness.isNameExist(username, userId, customId);
    }

    public void saveUser(TUser user, Long[] roleId) {
        this.userBusiness.saveUser(user, roleId);
    }

    public TUser findById(Long userId) {
        return this.userBusiness.findById(userId);
    }

    public void startUser(Long userId) {
        if (null == userId) {
            throw new IllegalArgumentException("\u7528\u6237Id\u4e3a\u7a7a");
        }
        this.userBusiness.updateUserStatus(userId, UserStatus.normalStatus.getValue());
    }

    public void pauseUser(Long userId) {
        if (null == userId) {
            throw new IllegalArgumentException("\u7528\u6237Id\u4e3a\u7a7a");
        }
        this.userBusiness.updateUserStatus(userId, UserStatus.stopStatus.getValue());
    }

    public Object[] queryUserCertByCardId(String cert) {
        if (StringUtils.isNotBlank((CharSequence)cert)) {
            Object[] returnArray = new Object[3];
            String[] certArray = cert.split("#");
            String cardId = certArray[0];
            returnArray[0] = cardId;
            X509Certificate clientCert = CertUtil.getCertFromStr16((String)certArray[1]);
            String snToBind = clientCert.getSerialNumber().toString(16).toLowerCase();
            returnArray[1] = snToBind;
            returnArray[2] = 0 < this.userBusiness.queryUserCertByCardId(cardId) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            return returnArray;
        }
        throw new IllegalArgumentException("\u7528\u6237Id\u4e3a\u7a7a");
    }

    public LitePaging<TUserCert> queryAllUserCert(Long userId, int pageNo, int pageSize) {
        if (null != userId) {
            return PagingConverter.convert(this.userBusiness.queryAllUserCert(userId, pageNo, pageSize));
        }
        throw new IllegalArgumentException("\u7528\u6237id\u4e3a\u7a7a");
    }

    public void deleteCard(Long userCertId) {
        if (null == userCertId) {
            throw new IllegalArgumentException("\u5361\u7ed1\u5b9aId\u4e3a\u7a7a");
        }
        this.userBusiness.deleteCard(userCertId);
    }

    public void saveUserCert(TUserCert userCert) {
        if (null != userCert) {
            Integer bindCount = this.userBusiness.queryUserCertByCardId(userCert.getCardId());
            if (0 != bindCount) {
                throw new IllegalArgumentException("\u5b89\u5168\u5361\u5df2\u88ab\u4f7f\u7528");
            }
        } else {
            throw new IllegalArgumentException("\u4fdd\u5b58\u4fe1\u606f\u4e3a\u7a7a");
        }
        this.userBusiness.saveUserCert(userCert);
    }
}

