/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.tpoms.web.log.action;

import com.xdja.cssp.tpoms.log.entity.SystemLog;
import com.xdja.cssp.tpoms.log.service.ISystemLogService;
import com.xdja.cssp.tpoms.log.util.DateQueryBean;
import com.xdja.cssp.tpoms.system.entity.TUser;
import com.xdja.cssp.tpoms.system.service.IUserService;
import com.xdja.cssp.tpoms.web.json.DataTablesParameters;
import com.xdja.cssp.tpoms.web.util.SystemLogExportUtil;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import com.xdja.platform.security.utils.OperatorUtil;
import com.xdja.platform.web.action.BaseAction;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/log/syslog/"})
public class SystemLogAction
extends BaseAction {
    private ISystemLogService systemLogService = (ISystemLogService)DefaultServiceRefer.getServiceRefer(ISystemLogService.class);
    private IUserService userService = (IUserService)DefaultServiceRefer.getServiceRefer(IUserService.class);

    @RequestMapping(value={"index"})
    public String index(ModelMap modelMap) {
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        modelMap.addAttribute("users", (Object)this.userService.queryAllUsers(currUser.getCustomId()));
        return "log/syslog/index";
    }

    @RequestMapping(value={"ajaxList"})
    @ResponseBody
    public Object ajaxList(SystemLog condition, DateQueryBean queryBean) {
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        condition.setCustomId(currUser.getCustomId());
        DataTablesParameters tables = DataTablesParameters.newInstance();
        String[] orderColumns = new String[]{"", "logType", "logTime"};
        LitePaging pagination = this.systemLogService.querySystemLogs(condition, Integer.valueOf(tables.getPage()), Integer.valueOf(tables.getLength()), tables.getOrderColName(orderColumns), tables.getOrderDir(), queryBean);
        return tables.getDataTablesReply(pagination);
    }

    @RequestMapping(value={"downloadSysLogs"})
    public void downloadSysLogs(SystemLog condition, DateQueryBean queryBean, HttpServletResponse response) {
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        condition.setCustomId(currUser.getCustomId());
        List systemLogs = this.systemLogService.querySystemLogs(condition, queryBean);
        try {
            InputStream in = SystemLogExportUtil.exportLogs((List)systemLogs);
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=systemlogs.xls");
            this.downloadFile(in, response);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(InputStream in, HttpServletResponse response) {
        ServletOutputStream out = null;
        try {
            byte[] fbytes = new byte[1024];
            int length = 0;
            out = response.getOutputStream();
            while ((length = in.read(fbytes, 0, fbytes.length)) != -1) {
                out.write(fbytes, 0, length);
            }
            out.flush();
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                    in = null;
                }
                if (out != null) {
                    out.close();
                    out = null;
                }
            }
            catch (IOException e) {}
        }
    }
}

