/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.tpoms.web.oder.action;

import com.xdja.cssp.oms.customer.bean.ChipsResultBean;
import com.xdja.cssp.oms.customer.bean.CustomerOrderResultBean;
import com.xdja.cssp.oms.customer.service.ITpOmsService;
import com.xdja.cssp.tpoms.system.entity.TUser;
import com.xdja.cssp.tpoms.web.json.DataTablesParameters;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import com.xdja.platform.security.utils.OperatorUtil;
import com.xdja.platform.web.action.BaseAction;
import java.util.List;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class OrderManagerAction
extends BaseAction {
    private ITpOmsService tpomsService = (ITpOmsService)DefaultServiceRefer.getServiceRefer(ITpOmsService.class);

    @RequestMapping(value={"order/index"})
    public String index() {
        return "order/index";
    }

    @RequestMapping(value={"order/list"})
    @ResponseBody
    public Object list(String name) {
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        DataTablesParameters tables = DataTablesParameters.newInstance();
        int index = (tables.getPage() - 1) * tables.getLength();
        CustomerOrderResultBean orders = this.tpomsService.queryOrders(currUser.getCustomId(), name, Integer.valueOf(index), Integer.valueOf(tables.getLength()));
        List orderList = orders.getOrderList();
        LitePaging bean = new LitePaging();
        bean.setDataList(orderList);
        bean.setTotalCount(Integer.valueOf(Integer.parseInt(orders.getTotalCount() + "")));
        return tables.getDataTablesReply(bean);
    }

    @RequestMapping(value={"order/detail"})
    public String detail() {
        return "order/detail";
    }

    @RequestMapping(value={"order/show"})
    @ResponseBody
    public Object show(Long orderId, Integer activateStatus) {
        DataTablesParameters tables = DataTablesParameters.newInstance();
        int index = (tables.getPage() - 1) * tables.getLength();
        ChipsResultBean orderDetail = this.tpomsService.queryOrderDetail(orderId, activateStatus, Integer.valueOf(index), Integer.valueOf(tables.getLength()));
        List chipList = orderDetail.getChipList();
        LitePaging bean = new LitePaging();
        bean.setDataList(chipList);
        bean.setTotalCount(Integer.valueOf(Integer.parseInt(orderDetail.getTotalCount() + "")));
        return tables.getDataTablesReply(bean);
    }
}

