/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.tpoms.web.security.action;

import com.xdja.cssp.tpoms.log.entity.SystemLog;
import com.xdja.cssp.tpoms.system.entity.TUser;
import com.xdja.cssp.tpoms.system.service.IFunctionService;
import com.xdja.cssp.tpoms.system.service.IUserService;
import com.xdja.cssp.tpoms.web.security.provider.UsernameCardIdToken;
import com.xdja.cssp.tpoms.web.util.CardUtil;
import com.xdja.cssp.tpoms.web.util.WebConstants;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.security.bean.Operator;
import com.xdja.platform.security.utils.OperatorUtil;
import com.xdja.platform.web.action.BaseAction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class LoginAction
extends BaseAction {
    private IFunctionService functionService = (IFunctionService)DefaultServiceRefer.getServiceRefer(IFunctionService.class);
    private IUserService userService = (IUserService)DefaultServiceRefer.getServiceRefer(IUserService.class);

    @RequestMapping(value={"/login"}, method={RequestMethod.GET})
    public String login(ModelMap model, HttpServletRequest request) {
        StringBuilder url = new StringBuilder("https://");
        url.append(request.getServerName()).append(":").append(WebConstants.HTTPS_PORT).append(request.getRequestURI());
        model.addAttribute("loginUrl", (Object)url.toString());
        return "login";
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    public String login(String userName, String cardId, ModelMap model, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            model.addAttribute("message", (Object)"\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (!CardUtil.checkCardNo((String)cardId, (HttpServletRequest)request)) {
            model.addAttribute("message", (Object)"\u5b89\u5168\u5361\u8bc1\u4e66\u8ba4\u8bc1\u5931\u8d25");
        } else {
            boolean isLogined = true;
            try {
                UsernameCardIdToken token = new UsernameCardIdToken(userName);
                token.setCardId(cardId);
                SecurityUtils.getSubject().login((AuthenticationToken)token);
            }
            catch (LockedAccountException e) {
                isLogined = false;
                model.addAttribute("message", (Object)"\u7528\u6237\u88ab\u9501\u5b9a");
            }
            catch (UnknownAccountException e) {
                isLogined = false;
                model.addAttribute("message", (Object)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            }
            catch (IncorrectCredentialsException e) {
                isLogined = false;
                model.addAttribute("message", (Object)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            }
            catch (AuthenticationException e) {
                isLogined = false;
                model.addAttribute("message", (Object)e.getMessage());
            }
            if (isLogined) {
                TUser user = this.userService.getUserByUserName(userName);
                user.setCardId(cardId);
                user.setLoginIp(request.getRemoteHost());
                OperatorUtil.setOperator((Operator)new Operator(userName, this.functionService.queryAllFunctions(user), (Object)user));
                this.logger.info(SystemLog.LogType.loginLog.getValue().intValue(), "\u7ba1\u7406\u5458{}\u767b\u5f55\u6210\u529f", (Object)user.getUsername());
                return "redirect:/index.do";
            }
        }
        model.addAttribute("userName", (Object)userName);
        model.addAttribute("error", (Object)"true");
        return "login";
    }

    @RequestMapping(value={"/logout"})
    public String logout(HttpServletResponse response) {
        TUser user = (TUser)OperatorUtil.getOperator().getCurrUser();
        this.logger.info(SystemLog.LogType.loginLog.getValue().intValue(), "\u7ba1\u7406\u5458{}\u9000\u51fa\u6210\u529f", (Object)user.getUsername());
        SecurityUtils.getSubject().logout();
        return "redirect:/login.do";
    }
}

