/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.tpoms.web.system.action;

import com.xdja.cssp.tpoms.log.entity.SystemLog;
import com.xdja.cssp.tpoms.system.entity.TRole;
import com.xdja.cssp.tpoms.system.entity.TUser;
import com.xdja.cssp.tpoms.system.service.IFunctionService;
import com.xdja.cssp.tpoms.system.service.IRoleService;
import com.xdja.cssp.tpoms.web.json.DataTablesParameters;
import com.xdja.cssp.tpoms.web.util.EncoderUtil;
import com.xdja.cssp.tpoms.web.util.WebConstants;
import com.xdja.platform.log.LoggerExtData;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import com.xdja.platform.security.utils.OperatorUtil;
import com.xdja.platform.web.action.BaseAction;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system/role/"})
public class RoleManagerAction
extends BaseAction {
    private IRoleService roleService = (IRoleService)DefaultServiceRefer.getServiceRefer(IRoleService.class);
    private IFunctionService functionService = (IFunctionService)DefaultServiceRefer.getServiceRefer(IFunctionService.class);

    @RequestMapping(value={"index"})
    public String index() {
        return "system/role/index";
    }

    @RequestMapping(value={"ajaxList"})
    @ResponseBody
    public Object ajaxList(String searchKey) {
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        DataTablesParameters tables = DataTablesParameters.newInstance();
        LitePaging pagination = this.roleService.queryAllRoles(currUser.getCustomId(), searchKey, Integer.valueOf(tables.getPage()), Integer.valueOf(tables.getLength()));
        return tables.getDataTablesReply(pagination);
    }

    @RequestMapping(value={"toAdd"})
    public String toAdd(ModelMap modelMap) {
        modelMap.addAttribute("roleFuncTree", (Object)this.toJsonStr((Object)this.roleService.queryAllFunctions(null)));
        return "system/role/add";
    }

    @RequestMapping(value={"save"})
    public void save(TRole role, String funcIds, HttpServletResponse response) {
        String message = "success";
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        try {
            role.setCustomId(currUser.getCustomId());
            role.setCreateUser(currUser.getUsername());
            this.roleService.saveRole(role, funcIds);
            if (null == role.getId()) {
                this.logger.info(SystemLog.LogType.operateLog.getValue().intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.LogModelType.systemManager.getValue()), "\u7ba1\u7406\u5458{}\u6dfb\u52a0\u89d2\u8272{}\u6210\u529f", (Object)currUser.getUsername(), (Object)role.getName());
            } else {
                this.logger.info(SystemLog.LogType.operateLog.getValue().intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.LogModelType.systemManager.getValue()), "\u7ba1\u7406\u5458{}\u4fee\u6539\u89d2\u8272{}\u6210\u529f", (Object)currUser.getUsername(), (Object)role.getName());
            }
        }
        catch (IllegalArgumentException e) {
            message = e.getMessage();
            this.logger.error("\u7ba1\u7406\u5458{}\u4fdd\u5b58\u89d2\u8272{}\u65f6\u53c2\u6570\u5f02\u5e38", (Object)currUser.getUsername(), (Object)role.getName());
        }
        catch (Exception e) {
            message = "\u4fdd\u5b58\u89d2\u8272\u5931\u8d25";
            this.logger.error("\u7ba1\u7406\u5458{}\u4fdd\u5b58\u89d2\u8272{}\u65f6\u51fa\u73b0\u5f02\u5e38", (Object)currUser.getUsername(), (Object)role.getName());
        }
        this.renderText(response, message);
    }

    @RequestMapping(value={"toEdit"})
    public String toEdit(Long roleId, ModelMap modelMap) {
        TRole role = this.roleService.getRoleById(roleId);
        modelMap.addAttribute("role", (Object)role);
        modelMap.addAttribute("roleFuncTree", (Object)this.toJsonStr((Object)this.roleService.queryAllFunctions(roleId)));
        return "system/role/edit";
    }

    @RequestMapping(value={"delete"})
    public void delete(Long roleId, String roleName, HttpServletResponse response) {
        String message = "success";
        TUser user = (TUser)OperatorUtil.getOperator().getCurrUser();
        try {
            boolean isSuccDel = this.roleService.deleteRoleById(roleId);
            if (!isSuccDel) {
                message = "\u5f53\u524d\u89d2\u8272\u88ab\u7528\u6237\u7ed1\u5b9a\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01";
                this.logger.info(SystemLog.LogType.operateLog.getValue().intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.LogModelType.systemManager.getValue()), "\u7ba1\u7406\u5458{}\u5220\u9664{}\u89d2\u8272\u5931\u8d25\uff0c\u5f53\u524d\u89d2\u8272\u5df2\u88ab\u7528\u6237\u7ed1\u5b9a", (Object)user.getUsername(), (Object)roleName);
            } else {
                this.logger.info(SystemLog.LogType.operateLog.getValue().intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.LogModelType.systemManager.getValue()), "\u7ba1\u7406\u5458{}\u5220\u9664{}\u89d2\u8272\u6210\u529f", (Object)user.getUsername(), (Object)roleName);
            }
        }
        catch (IllegalArgumentException e) {
            message = e.getMessage();
            this.logger.error("\u7ba1\u7406\u5458{}\u5220\u9664{}\u89d2\u8272\u65f6\u53c2\u6570\u5f02\u5e38", (Object)user.getUsername(), (Object)roleName);
        }
        catch (Exception e) {
            message = "\u5220\u9664\u89d2\u8272\u5931\u8d25";
            this.logger.error("\u7ba1\u7406\u5458{}\u5220\u9664{}\u89d2\u8272\u65f6\u5f02\u5e38", (Object)user.getUsername(), (Object)roleName);
        }
        this.renderText(response, message);
    }

    @RequestMapping(value={"checkRoleName"})
    @ResponseBody
    public Object checkRoleName(Long roleId, String name) {
        try {
            TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
            return this.roleService.isRoleNameExist(roleId, name, currUser.getCustomId()) ? EncoderUtil.encode((String)"\u89d2\u8272\u540d\u91cd\u590d") : "success";
        }
        catch (Exception e) {
            this.logger.error("\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            return EncoderUtil.encode((String)WebConstants.SERVICE_BREAKE);
        }
    }
}

