/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.tpoms.web.system.action;

import com.xdja.cssp.tpoms.log.entity.SystemLog;
import com.xdja.cssp.tpoms.system.entity.TUser;
import com.xdja.cssp.tpoms.system.entity.TUserCert;
import com.xdja.cssp.tpoms.system.service.IRoleService;
import com.xdja.cssp.tpoms.system.service.IUserService;
import com.xdja.cssp.tpoms.web.json.DataTablesParameters;
import com.xdja.cssp.tpoms.web.util.EncoderUtil;
import com.xdja.platform.log.LoggerExtData;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import com.xdja.platform.security.utils.OperatorUtil;
import com.xdja.platform.web.action.BaseAction;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system/user/"})
public class UserManagerAction
extends BaseAction {
    private IUserService userService = (IUserService)DefaultServiceRefer.getServiceRefer(IUserService.class);
    private IRoleService roleService = (IRoleService)DefaultServiceRefer.getServiceRefer(IRoleService.class);

    @RequestMapping(value={"index"})
    public String index() {
        return "system/user/index";
    }

    @RequestMapping(value={"ajaxList"})
    @ResponseBody
    public Object ajaxList(String searchKey) {
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        DataTablesParameters tables = DataTablesParameters.newInstance();
        LitePaging pagination = this.userService.queryAllUsers(currUser, searchKey, Integer.valueOf(tables.getPage()), Integer.valueOf(tables.getLength()));
        return tables.getDataTablesReply(pagination);
    }

    @RequestMapping(value={"toAdd"})
    public String toAdd(ModelMap modelMap) {
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        List roleList = this.roleService.queryAllRoles(currUser.getCustomId());
        modelMap.addAttribute("roles", (Object)roleList);
        return "system/user/add";
    }

    @RequestMapping(value={"checkUserName"})
    @ResponseBody
    public Object checkUserName(String username, Long userId) {
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        return this.userService.isNameExist(username, userId, currUser.getCustomId()) ? EncoderUtil.encode((String)"\u7528\u6237\u540d\u91cd\u590d") : "success";
    }

    @RequestMapping(value={"save"})
    public void save(TUser user, Long[] roleId, HttpServletResponse response) {
        String message = "success";
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        user.setCustomId(currUser.getCustomId());
        this.userService.saveUser(user, roleId);
        if (null != user.getId()) {
            this.logger.info(SystemLog.LogType.operateLog.getValue().intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.LogModelType.systemManager.getValue()), "\u7ba1\u7406\u5458{}\u4fee\u6539{}\u7528\u6237\u6210\u529f", (Object)currUser.getUsername(), (Object)user.getUsername());
        } else {
            this.logger.info(SystemLog.LogType.operateLog.getValue().intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.LogModelType.systemManager.getValue()), "\u7ba1\u7406\u5458{}\u6dfb\u52a0{}\u7528\u6237\u6210\u529f", (Object)currUser.getUsername(), (Object)user.getUsername());
        }
        this.renderText(response, message);
    }

    @RequestMapping(value={"toEdit"})
    public String toEdit(Long userId, ModelMap modelMap) {
        TUser user = this.userService.findById(userId);
        List roleList = this.roleService.queryListRolesOrCheck(user);
        modelMap.put((Object)"user", (Object)user);
        modelMap.addAttribute("roles", (Object)roleList);
        return "system/user/edit";
    }

    @RequestMapping(value={"toBind"})
    public String toBind(Long userId, ModelMap modelMap) {
        TUser currentUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        modelMap.put((Object)"userId", (Object)userId);
        modelMap.put((Object)"loginUserCardId", (Object)currentUser.getCardId());
        return "system/user/bind";
    }

    @RequestMapping(value={"ajaxCardList.do"})
    @ResponseBody
    public Object ajaxCardList(Long userId) {
        DataTablesParameters tables = DataTablesParameters.newInstance();
        LitePaging pagination = this.userService.queryAllUserCert(userId, tables.getPage(), tables.getLength());
        return tables.getDataTablesReply(pagination);
    }

    @RequestMapping(value={"deleteCard"})
    public void deleteCard(Long userCertId, Long userId, HttpServletResponse response) {
        String message = "success";
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        try {
            this.userService.deleteCard(userCertId);
            this.logger.info(SystemLog.LogType.operateLog.getValue().intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.LogModelType.systemManager.getValue()), "\u7ba1\u7406\u5458{}\u4e3a\u7528\u6237\u64a4\u9500\u5b89\u5168\u5361\uff0c\u7528\u6237id\u4e3a{}", (Object)currUser.getUsername(), (Object)userId);
        }
        catch (IllegalArgumentException e) {
            message = e.getMessage();
            this.logger.error("\u64a4\u9500\u7528\u6237\u7ed1\u5b9a\u5361\u65f6\uff0c\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        catch (Exception e) {
            message = "\u64a4\u9500\u5361\u7ed1\u5b9a\u5931\u8d25";
            this.logger.error("\u5361\u7ed1\u5b9a\u65f6\u64cd\u4f5c\u65f6\u5f02\u5e38", (Throwable)e);
        }
        this.renderText(response, message);
    }

    @RequestMapping(value={"saveCard"})
    public void saveCard(TUserCert userCert, HttpServletResponse response) {
        String message = "success";
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        try {
            this.userService.saveUserCert(userCert);
            this.logger.info(SystemLog.LogType.operateLog.getValue().intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.LogModelType.systemManager.getValue()), "\u7ba1\u7406\u5458{}\u4e3a\u7528\u6237\u7ed1\u5b9a\u4e86\u5b89\u5168\u5361\uff0c\u7528\u6237id\u4e3a{}", (Object)currUser.getUsername(), (Object)userCert.getUserId());
        }
        catch (IllegalArgumentException e) {
            message = e.getMessage();
            this.logger.error("\u5361\u7ed1\u5b9a\u65f6\uff0c\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        catch (Exception e) {
            message = "\u5361\u7ed1\u5b9a\u5931\u8d25";
            this.logger.error("\u5361\u7ed1\u5b9a\u65f6\u64cd\u4f5c\u65f6\u5f02\u5e38", (Throwable)e);
        }
        this.renderText(response, message);
    }

    @RequestMapping(value={"getCardSn"})
    public void getCardSn(String cert, HttpServletResponse response) {
        String result = "";
        try {
            Object[] certArray = this.userService.queryUserCertByCardId(cert);
            result = !((Boolean)certArray[2]).booleanValue() ? "{\"flag\":\"success\",\"sn\":\"" + certArray[1] + "\",\"cardId\":\"" + certArray[0] + "\"}" : "{\"flag\":\"error\", \"message\":\"\u5b89\u5168\u5361\u5df2\u88ab\u4f7f\u7528\"}";
        }
        catch (Exception e) {
            result = "{\"flag\":\"error\", \"message\":\"\u5b89\u5168\u5361\u6821\u9a8c\u5931\u8d25\"}";
            this.logger.error("\u5b89\u5168\u5361\u6821\u9a8c\u65f6\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a", (Throwable)e);
        }
        this.renderJson(response, result);
    }

    @RequestMapping(value={"pauseUser"})
    public void pauseUser(Long userId, HttpServletResponse response) {
        String message = "success";
        TUser user = this.userService.findById(userId);
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        try {
            this.userService.pauseUser(userId);
            this.logger.info(SystemLog.LogType.operateLog.getValue().intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.LogModelType.systemManager.getValue()), "\u7ba1\u7406\u5458{}\u6682\u505c{}\u7528\u6237\u6210\u529f", (Object)currUser.getUsername(), (Object)user.getUsername());
        }
        catch (IllegalArgumentException e) {
            message = e.getMessage();
            this.logger.error("\u6682\u505c\u7528\u6237\u65f6\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        catch (Exception e) {
            message = "\u6682\u505c\u7528\u6237\u5931\u8d25";
            this.logger.error("\u6682\u505c\u7528\u6237\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a", (Throwable)e);
        }
        this.renderText(response, message);
    }

    @RequestMapping(value={"startUser"})
    public void startUser(Long userId, HttpServletResponse response) {
        String message = "success";
        TUser user = this.userService.findById(userId);
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        try {
            this.userService.startUser(userId);
            this.logger.info(SystemLog.LogType.operateLog.getValue().intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.LogModelType.systemManager.getValue()), "\u7ba1\u7406\u5458{}\u542f\u7528{}\u7528\u6237\u6210\u529f", (Object)currUser.getUsername(), (Object)user.getUsername());
        }
        catch (IllegalArgumentException e) {
            message = e.getMessage();
            this.logger.error("\u542f\u7528\u7528\u6237\u65f6\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        catch (Exception e) {
            message = "\u542f\u7528\u7528\u6237\u5931\u8d25";
            this.logger.error("\u542f\u7528\u7528\u6237\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a", (Throwable)e);
        }
        this.renderText(response, message);
    }
}

