/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.tpoms.web.util;

import com.xdja.cssp.tpoms.web.util.Card;
import java.io.ByteArrayInputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CertUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(CertUtil.class);
    public static final String CERT_HEAD = "-----BEGIN CERTIFICATE-----";
    public static final String CERT_TAIL = "-----END CERTIFICATE-----";

    public static X509Certificate getCertFromStr16(String str) {
        byte[] bs = CertUtil.hex2byte((String)str);
        CertificateFactory cf = null;
        X509Certificate x509Cert = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream inStream = new ByteArrayInputStream(bs);
            x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            LOG.error("getCertFromFullStr error: " + e.toString());
            return null;
        }
    }

    public static byte[] hex2byte(String str) {
        if (null == str || str.equals("")) {
            return null;
        }
        StringBuffer sb = new StringBuffer(str = str.trim());
        int len = sb.length();
        if (len == 0 || len % 2 == 1) {
            return null;
        }
        byte[] b = new byte[len / 2];
        try {
            for (int i = 0; i < len; i += 2) {
                b[i / 2] = (byte)Integer.decode("0x" + sb.substring(i, i + 2)).intValue();
            }
            return b;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getPubKey(String str) {
        LOG.debug("\u8fdb\u5165CertUtil->getPubKey: str:\n" + str);
        X509Certificate x509Cert = CertUtil.getCertFromStr((String)str);
        RSAPublicKey rsa = (RSAPublicKey)x509Cert.getPublicKey();
        String pubKey = rsa.getModulus().toString(16).toUpperCase();
        return pubKey;
    }

    public static X509Certificate getCertFromStr(String str) {
        X509Certificate x509Cert = null;
        x509Cert = CertUtil.getCertFromStr16((String)str);
        if (x509Cert == null) {
            x509Cert = CertUtil.getCertFromB64((String)str);
        }
        if (x509Cert == null) {
            x509Cert = CertUtil.getCertFromFullStr((String)str);
        }
        return x509Cert;
    }

    public static X509Certificate getCertFromFullStr(String str) {
        CertificateFactory cf = null;
        X509Certificate x509Cert = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream inStream = new ByteArrayInputStream(str.getBytes());
            x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            LOG.error("getCertFromFullStr error: " + e.toString());
            return null;
        }
    }

    public static X509Certificate getCertFromB64(String b64) {
        CertificateFactory cf = null;
        X509Certificate x509Cert = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
            byte[] bsCert = Base64.decodeBase64((byte[])b64.getBytes());
            ByteArrayInputStream inStream = new ByteArrayInputStream(bsCert);
            x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("getCertFromB64 error: " + e.toString());
            return null;
        }
    }

    public static String certToFullB64(Certificate cert) {
        String certb64 = "";
        try {
            certb64 = CertUtil.bytesToFullB64((byte[])cert.getEncoded());
        }
        catch (Exception e) {
            LOG.error("certToFullB64 error:" + e.toString());
            e.printStackTrace();
        }
        return certb64;
    }

    public static String bytesToFullB64(byte[] certder) {
        String certb64 = null;
        try {
            certb64 = new String(Base64.encodeBase64((byte[])certder));
            certb64 = "-----BEGIN CERTIFICATE-----\n" + certb64 + "\n" + "-----END CERTIFICATE-----" + "\n";
            return certb64;
        }
        catch (Exception e) {
            LOG.error("certDerToFullB64 error:" + e.toString());
            e.printStackTrace();
            return null;
        }
    }

    public static String getSub(String dn, String cn) {
        if (dn == null || dn.length() == 0 || cn == null || cn.length() == 0) {
            return null;
        }
        String[] items = dn.split(",");
        if (items == null || items.length == 0) {
            return null;
        }
        for (int i = 0; i < items.length; ++i) {
            String[] item = items[i].split("=");
            if (item == null || item.length != 2) continue;
            for (int j = 0; j < item.length; ++j) {
                item[j] = item[j].trim();
            }
            if (!item[0].equalsIgnoreCase(cn)) continue;
            return item[1];
        }
        return null;
    }

    public static Card getCard(X509Certificate cert) {
        String cardSn = cert.getSerialNumber().toString(16).toLowerCase();
        String cardNo = CertUtil.getSub((String)cert.getSubjectX500Principal().toString().replaceAll(", ", ","), (String)"cn");
        if (cardNo.startsWith("s_")) {
            cardNo = cardNo.substring(2);
        }
        return new Card(cardNo, cardSn, Card.CaAlgType.getCaAlg((String)cert.getSigAlgName(), (String)cert.getSigAlgOID()));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

