/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.tpoms.web.util;

import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class PropertiesUtil {
    private static Properties props = null;
    private static final Logger logger = LoggerFactory.getLogger(PropertiesUtil.class);
    private ResourceLoader resourceLoader = new DefaultResourceLoader();

    private PropertiesUtil(String propertiesName) {
        props = new Properties();
        Resource resource = this.resourceLoader.getResource("classpath:" + propertiesName);
        try {
            props.load(resource.getInputStream());
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", (Throwable)e);
        }
    }

    public static PropertiesUtil createProUtil(String propertiesName) {
        return new PropertiesUtil(propertiesName);
    }

    public String getPropStringValue(String propkey, String defaultValue) {
        return props.getProperty(propkey, defaultValue);
    }

    public int getPropIntValue(String propkey, String defaultValue) {
        return Integer.valueOf(props.getProperty(propkey, defaultValue));
    }
}

