/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.platform.core;

import com.xdja.cssp.tpoms.web.util.WebConstants;
import com.xdja.platform.common.lite.kit.StrKit;
import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.log.LoggerFactory;
import com.xdja.platform.microservice.ServiceException;
import com.xdja.platform.microservice.db.DataSourceProvider;
import com.xdja.platform.microservice.db.druid.DruidPlugin;
import com.xdja.platform.microservice.db.nutz.NutzDaoPlugin;
import com.xdja.platform.rpc.consumer.IService;
import com.xdja.platform.rpc.consumer.Service;
import com.xdja.platform.rpc.consumer.ServicePool;
import com.xdja.platform.rpc.proxy.PagingConverter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class ApplicationInit {
    public static Prop sysProp;
    private static final Logger logger;
    private static final String SERVICES = "tpoms";
    public static final String SERVERIP = "127.0.0.1";
    public static final int SERVERPORT = 6666;
    public static final int SESSION_TIMEOUT = 10000;

    public static void initialize() {
        String[] services;
        sysProp = PropKit.use((String)"system.properties");
        Service rpcService = null;
        for (String service : services = StringUtils.split((String)sysProp.get("rpc.services", SERVICES), (String)"|")) {
            rpcService = new Service();
            rpcService.setAddr(sysProp.get("rpc." + service + ".ip", SERVERIP));
            rpcService.setPort(sysProp.getInt("rpc." + service + ".port", Integer.valueOf(6666)).intValue());
            rpcService.setTimeoutMillis((long)sysProp.getInt("rpc." + service + ".timeoutMillis", Integer.valueOf(10000)).intValue());
            ServicePool.addService((String)service, (IService)rpcService);
            logger.info("\u6ce8\u518crpc service\uff08{}==>{}:{}\uff09\u6210\u529f", new Object[]{service, rpcService.getAddr(), rpcService.getPort()});
        }
        WebConstants.HTTPS_PORT = sysProp.getInt("https.port", Integer.valueOf(8443));
        PagingConverter.pageNoMethodName = "getPageNo";
        PagingConverter.pageSizeMethodName = "getPageSize";
        PagingConverter.totalCountMethodName = "getTotalCount";
        PagingConverter.totalPageMethodName = "getTotalPage";
        PagingConverter.dataListMethodName = "getList";
    }

    private static void initDataSource() throws Exception {
        String dbNamesStr = sysProp.get("dbnames");
        if (StrKit.isBlank((String)dbNamesStr)) {
            throw ServiceException.create((String)"\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6system.properties\u4e2d\u6dfb\u52a0dbNames\u7684\u914d\u7f6e", null);
        }
        String[] dbNames = StringUtils.split((String)dbNamesStr, (String)"|");
        System.out.println(dbNames[0]);
        String url = null;
        String userName = null;
        String password = null;
        DruidPlugin plugin = null;
        NutzDaoPlugin daoPlugin = null;
        for (String dbName : dbNames) {
            url = sysProp.get(dbName + ".jdbc.url");
            if (StrKit.isBlank((String)url)) {
                throw ServiceException.create((String)("\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6system.properties\u4e2d\u6dfb\u52a0" + dbName + "jdbcUrl\u7684\u914d\u7f6e"), null);
            }
            userName = sysProp.get(dbName + ".jdbc.userName");
            if (StrKit.isBlank((String)userName)) {
                throw ServiceException.create((String)("\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6system.properties\u4e2d\u6dfb\u52a0" + dbName + "userName\u7684\u914d\u7f6e"), null);
            }
            password = sysProp.get(dbName + ".jdbc.password");
            plugin = new DruidPlugin(url, userName, password);
            plugin.start();
            daoPlugin = new NutzDaoPlugin("db::" + dbName, (DataSourceProvider)plugin);
            if (!sysProp.getBoolean(dbName + ".jdbc.debug", Boolean.valueOf(true)).booleanValue()) {
                daoPlugin.disableDebug();
            }
            daoPlugin.start();
        }
    }

    static {
        logger = LoggerFactory.getLogger(ApplicationInit.class);
    }
}

