<#macro layout title="第三方运营管理系统" link="" >
<!DOCTYPE html html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html lang="zh-CN">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<title>${title}</title>
<link rel="shortcut icon" href="${base}/image/tpoms.ico" type="image/png" />
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<link rel="stylesheet" type="text/css" href="${base}/themes/default/css/bootstrap.min.css" />
<link rel="stylesheet" type="text/css" href="${base}/themes/default/css/default.css" />
<link rel="stylesheet" type="text/css" href="${base}/themes/default/css/style.css" />

<script type="text/javascript" src="${base}/script/jquery-1.10.2.js"></script>
<script type="text/javascript" src="${base}/script/app.js"></script>
<script type="text/javascript" src="${base}/script/bootstrap.min.js"></script>
<@p.script value=["card"] />
<script type="text/javascript">var base = '${base}';</script>
</head>
<body class="page-header-fixed ">

<!-- 主内容开始 -->   
<div class="page-container row-fluid">
	<div class="page-sidebar">
		<div class="head overflowh">
			<div class="pull-left">
				<div class="displayim"><img src="${base}/themes/default/images/tpoms/small-logo.png" /></div>
				<div class="displayim"><img src="${base}/themes/default/images/tpoms/small-text.png" /></div>
			</div>
			<div class="pull-right" style="padding-top: 10px;">
				<div class="displayim">
					<div class="userName">
						<span>用户名 :</span>
						<span>${operator.username}</span>
					</div>
					<div class="exit" onclick="redirect('logout.do')"></div>
				</div>
			</div>
		</div>

	</div>
	<!-- END SIDEBAR -->
	<!-- BEGIN PAGE -->
	<div class="page-content">
		<!-- BEGIN PAGE CONTAINER-->
		
		<div class="nav-collapse collapse">
			<!-- 菜单开始 -->
			<ul class="nav page-sidebar-menu">			
				<#list operator.topMenus as menu>
						<#if menu.children?exists && menu.children?size gt 0>
							
							<#assign open=false />
							<#list menu.children as child >
								<#if child.properties['link'] == link>
									<#assign open=true />
								</#if>
							</#list>
							
							<li class="start<#if open> open active</#if>">
								<div class="menu-bg" onclick="redirect('${menu.children[0].properties['link']}')">
									<i class="${menu.properties['icon']}"></i> 
									<span class="title">${menu.name}</span>
								</div>
								<#if open> 
								<ul class="sub-menu">
									<#list menu.children as child >
										<li<#if child.properties['link'] == link> class="active"</#if>>
											<div onclick="redirect('${child.properties['link']}')">
												${child.name}
											</div>
										</li>
									</#list>
								</ul>
								</#if>
							</li>
							
							<#else>
							<li class="start<#if menu.properties['link'] == link> open active</#if>">
								<div onclick="redirect('${menu.properties['link']}')" class="menu-bg">
									<i class="${menu.properties['icon']}"></i> 
								   <span class="title">${menu.name}</span>
								</div>
							</li>
						</#if>
				</#list>
				<li class="backDiv" onclick="redirect('index.do')">
					<div>
						<i class="back"></i> 
						<span class="title">返回首页</span>
					</div>
				</li>
				<div class="clear"></div>
			</ul>
	
			<!-- END SIDEBAR MENU -->
		</div>
		
		<div class="content" >
			<div class="bianju">
				<#nested/><#t/>
			</div>
		</div>
	</div>
</div>


<div id="execptionContainer" class=""></div>

<script>
App.init();

$("body").delegate("a","focus",function(){
  $("a").blur();
});

function redirect(url){
	location.href = '${base}/' + url;
}

//所有的ajax请求在sesstion超时的时候都自动跳转到登录页面
$.ajaxSetup({
	global: false,
	complete:function(xhr, ts) {
		if(xhr.getResponseHeader("sessionstatus") == "timeout") {
			top.location.href = "${base}/login.do?sessionTimeoutFlag=true";
			return;
		}
		
		if(xhr.getResponseHeader("isException") === "true" && (xhr.getResponseHeader("Content-Type") === "text/html;charset=UTF-8" || xhr.getResponseHeader("Content-Type") === "text/html; charset=utf-8")) {
			openDialog({
	             height:540,
        		 width: 680,
	             title : '系统异常',
	             content: xhr.responseText
	         });
		}
	}
});
 
 
Card.ready(function(){
	 if(!this.success){
		 //错误描述
		 var errorDesc = {
		 	'0':'未安装读卡控件，请返回登录页面下载',
		 	'3':'读卡控件已经升级，请到登录页面下载安装后重新登录',
		 	'-100':'您的浏览器不支持安全控件'
		 };
		 
		logout(errorDesc[data.code]||data.meesage);
		return ;
	 }
	 
	//监听拔卡
	this.onpullcard('${operator.currUser.cardId!}', function(){
		logout("安全卡已被拔出，系统将强制退出");
	});
	
 });
 
 //退出登陆
function logout(message) {
	if(message) {alert(message);}
	top.location.href = "${base}/login.do";
}
</script>
</body>
</html>
</#macro>