(function($) { 
	$.fn.mdcselect = function(options){
		var defaults = {
			theme:'theme-gray', //默认皮肤
			boxHeight:'auto', //下拉框列表高度
			width:null, //宽度
			height:null //高度
		};
		var config = $.extend({}, defaults, options);
		
		this.css({
	        position: 'absolute',
	        left: '-999999px'
	    }).attr('tabindex', -1).addClass('mdc-dest-select');
		var height = parseInt(config.boxHeight);
		height = isNaN(height)? '': 'style="max-height:' + height + 'px"';
		
		this.next('.mdc-select').remove();
		this.after(function(){ //在select后面渲染
			var opts = $('option', this);
			var items = opts.map(function(){
				var _this = $(this);
				return '<li class="mdc-item" title="' + _this.text() + '">' + _this.html() + '</li>';
			}).get();
			items[this.selectedIndex] = items[this.selectedIndex].replace(/^<li class="mdc-item"/g, '<li class="mdc-item selected"');

			var template = 
			['<div class="mdc-select ' + config.theme + '" tabindex="-1">',
				'<div class="mdc-input-title" >',
			    	'<div class="mdc-text">{title}</div>',
			    	'<div class="mdc-btn-down">',
			    		'<div class="mdc-btn-caret"></div>',
			    	'</div>',
		    	'</div>',
		    	'<ul class="mdc-dropdown" ' + height + '>{dropdown}</ul>',
			'</div>'];
			
			template[2] = template[2].replace('{title}', opts.eq(this.selectedIndex).html());
			template[7] = template[7].replace('{dropdown}', items.join(''));
			return template.join('');
		});
	
		function _update(destSelect, index){
	       	var select = $(destSelect).next('.mdc-select');
			if(index == -1) {
					$('.mdc-text', select).text('');
			} else {
		        destSelect.selectedIndex = index;
		       	$('li.mdc-item', select).removeClass('selected').eq(index).addClass('selected');
		       	$('.mdc-text', select).text(destSelect.options[index].text);
       		}
	    }

	    this.change(function(evt){
		    _update(this, this.selectedIndex);
	    });
	    
		var mdc = this.next('.mdc-select');
		var dat;

		dat = parseInt(config.width);;
		if(isNaN(dat)){
			mdc.css('width', function(){
				dat = parseInt($(this).prev('select').data('width'));
				if(!isNaN(dat)) {
					return dat + 'px';
				}
			});
		}  else {
			!isNaN(dat) && mdc.css('width', dat + 'px');
		}
		
		
		dat = parseInt(config.height);
		//dat = parseInt(this.data('height'));
		if(isNaN(dat)){
			$('.mdc-text', mdc).css('padding', function(){
				dat = parseInt($(this).parent().parent().prev('select').data('height'));
				if(!isNaN(dat) && (dat = dat - 22) >= 0) {
					dat = dat/2 + 'px';
					return dat + ' 6px ' + dat + ' 26px';
				}
			});
		}  else if((dat = dat - 22) >= 0){
			dat = dat/2 + 'px';
			$('.mdc-text', mdc).css({'padding-top':dat, 'padding-bottom':dat});
		}
		
		mdc.blur(function(){
			$(this).removeClass('open');
		});
		
		mdc.keydown(function(e){
			var destSelect = $(this).prev('select.mdc-dest-select')[0];
        	var index = destSelect.selectedIndex;
        	
        	switch (e.which) {
        	case 13:
				$(this).toggleClass('open');
	        	return ;
        	case 38:
        		if (index - 1 > -1) {
	             	index = index - 1;
            		break;
	            } else {
	         		return;
         		}
        	case 40:
        		if (index + 1 < destSelect.options.length) {
        			index = index + 1;
         			break;
	            } else {
	         		return;
         		}
          	default:
            	return ;
          	}
          	
          	if (index > -1) {
            	destSelect.selectedIndex = index;
            	$(destSelect).change();
          	}
          	
          	return $(document).one('keydown', function(e){
            	if (e.which === 38 || e.which === 40) {
              		return e.preventDefault();
            	}
        	});
        });

		$('.mdc-input-title', mdc).click(function (evt){
			$(this).closest('.mdc-select').focus().toggleClass('open');
		});

		mdc.delegate('li.mdc-item', 'click', function (evt){
			var _this = $(this);
			var cls = _this.closest('.mdc-select').removeClass('open');
			var destSelect = cls.prev('select.mdc-dest-select')[0];
			if(destSelect.selectedIndex != _this.index()) {
				destSelect.selectedIndex = _this.index();
	            $(destSelect).change();
        	}
		});

		return this.each(function(i, n) {
			var add = this.options.add;
			this.options.add = function(option, value) {
				var opt = option;
				if(value) opt = new Option(option, value);
				add.call(this, opt);

				var dest = $(this).closest('.mdc-dest-select');
				$('.mdc-dropdown', dest.next('.mdc-select')).append('<li class="mdc-item" title="' + opt.text + '">' + opt.text + '</>');
				_update(dest[0], dest[0].selectedIndex);
			};

			var remove = this.remove;
			this.remove = function(index){
				remove.call(this, index);
				$('li.mdc-item', $(this).next('.mdc-select')).eq(index).remove();
				_update(this, this.selectedIndex);
			};

			if(/*@cc_on !@*/true) { //IE低版本会循环调用
				this.add = function(option, value) {
					this.options.add(option, value);
				};
			}
		});;
	};
})(jQuery);