/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.common.base;

import android.app.Activity;
import java.util.ArrayList;
import java.util.Stack;

public class ActivityStackManager {
    public static Stack<Activity> mActivityStack;
    private static ActivityStackManager mInstance;

    private ActivityStackManager() {
        mActivityStack = new Stack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ActivityStackManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<ActivityStackManager> clazz = ActivityStackManager.class;
        synchronized (ActivityStackManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new ActivityStackManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void addActivity(Activity activity) {
        mActivityStack.push(activity);
    }

    public void removeActivity(Activity activity) {
        mActivityStack.remove(activity);
    }

    public void finishAllActivity() {
        while (!mActivityStack.empty()) {
            Activity activity = mActivityStack.pop();
            if (activity == null) continue;
            activity.finish();
        }
    }

    public void finishActivity(Class<?> cls) {
        for (Activity activity : mActivityStack) {
            if (!activity.getClass().equals(cls)) continue;
            this.finishActivity(activity);
        }
    }

    public boolean checkActivity(Class<?> cls) {
        for (Activity activity : mActivityStack) {
            if (!activity.getClass().equals(cls)) continue;
            return true;
        }
        return false;
    }

    public void finishActivity(Activity activity) {
        if (activity != null) {
            mActivityStack.remove(activity);
            activity.finish();
            activity = null;
        }
    }

    public Activity getTopActivity() {
        if (mActivityStack != null && mActivityStack.size() > 0) {
            return mActivityStack.peek();
        }
        return null;
    }

    public boolean finishToActivity(Class<? extends Activity> actCls, boolean isIncludeSelf) {
        ArrayList<Activity> buf = new ArrayList<Activity>();
        int size = mActivityStack.size();
        Activity activity = null;
        for (int i = size - 1; i >= 0; --i) {
            activity = (Activity)mActivityStack.get(i);
            if (activity.getClass().isAssignableFrom(actCls)) {
                for (Activity a : buf) {
                    a.finish();
                }
                return true;
            }
            if (i == size - 1 && isIncludeSelf) {
                buf.add(activity);
                continue;
            }
            if (i == size - 1) continue;
            buf.add(activity);
        }
        return false;
    }
}

