/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.common.base;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AppCompatActivity;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.xdja.poc.common.R;
import com.xdja.poc.common.annotation.TitleViewAnnotation;
import com.xdja.poc.common.base.ActivityStackManager;
import com.xdja.poc.common.event.NetWorkConnectEvent;
import com.xdja.poc.common.rxpermissions2.RxPermissions;
import com.xdja.poc.common.style.SystemBarTintManager;
import com.xdja.poc.common.utils.DisplayUtil;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.NetUtils;
import com.xdja.poc.common.view.TitleBarView;
import java.util.Locale;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public abstract class BaseActivity
extends AppCompatActivity {
    public String TAG;
    private LinearLayout parent;
    public TitleBarView titleBarView;
    protected boolean isNetConnected;
    public static boolean isSelfActivity;
    public Toast toast;
    private TextView tvMsg;
    private SystemBarTintManager tintManager;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.TAG = ((Object)((Object)this)).getClass().getName();
        if (((Object)((Object)this)).getClass().isAnnotationPresent(TitleViewAnnotation.class)) {
            this.createRootView();
        } else {
            this.setContentView(this.generateLayout());
        }
        this.setTranslucentStatusBar();
        this.isNetConnected = NetUtils.isNetworkAvailable((Context)this);
        this.initView();
        this.initEvent();
        EventBus.getDefault().register((Object)this);
        ActivityStackManager.getInstance().addActivity((Activity)this);
        this.initToast();
    }

    private void initToast() {
        this.toast = new Toast((Context)this);
        this.toast.setDuration(0);
        LayoutInflater inflate = (LayoutInflater)this.getSystemService("layout_inflater");
        View v = inflate.inflate(R.layout.common_toast_layout, null);
        this.tvMsg = (TextView)v.findViewById(R.id.message);
        this.toast.setView(v);
    }

    public void showMessage(String message) {
        this.tvMsg.setText((CharSequence)message);
        this.toast.setDuration(0);
        this.toast.show();
    }

    private void createRootView() {
        this.parent = new LinearLayout((Context)this);
        this.parent.setOrientation(1);
        this.parent.setBackgroundColor(this.getResources().getColor(R.color.common_white_color));
        this.parent.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.titleBarView = new TitleBarView((Context)this);
        int titleBarHeight = DisplayUtil.dip2px((Context)this, 53.0f);
        LinearLayout.LayoutParams titleParams = new LinearLayout.LayoutParams(-1, titleBarHeight);
        this.parent.addView((View)this.titleBarView, (ViewGroup.LayoutParams)titleParams);
        this.setContentView((View)this.parent);
        if (this.generateLayout() != -1) {
            try {
                View view = this.getLayoutInflater().inflate(this.generateLayout(), null);
                this.parent.addView(view, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
            }
            catch (Throwable throwable) {
                LogUtils.ELog(throwable);
                this.finish();
            }
        }
    }

    protected abstract int getTranslucentStatusBarColor();

    public void checkPermision(String ... permissions) {
        try {
            RxPermissions rxPermissions = new RxPermissions((FragmentActivity)this);
            rxPermissions.request(permissions).subscribe(granted -> {
                if (granted.booleanValue()) {
                    LogUtils.ILog(this.TAG, "granted:" + granted);
                    this.onPermissionResult(true);
                } else {
                    LogUtils.ILog(this.TAG, "granted:" + granted);
                    this.onPermissionResult(false);
                }
            });
        }
        catch (Throwable e) {
            LogUtils.ELog(e);
        }
    }

    protected abstract void initView();

    protected abstract void initEvent();

    protected abstract int generateLayout();

    protected TitleBarView getTitleBarView() {
        return this.titleBarView;
    }

    public <T extends View> T $(@IdRes int id2) {
        return (T)this.findViewById(id2);
    }

    protected void onResume() {
        super.onResume();
        isSelfActivity = true;
    }

    protected void onDestroy() {
        super.onDestroy();
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
        ActivityStackManager.getInstance().finishActivity((Activity)this);
    }

    public Resources getResources() {
        Resources res = super.getResources();
        Configuration configuration = res.getConfiguration();
        configuration.setLocale(Locale.CHINA);
        configuration.fontScale = 1.0f;
        try {
            res.updateConfiguration(configuration, res.getDisplayMetrics());
        }
        catch (Exception ex) {
            LogUtils.ELog(ex);
        }
        return res;
    }

    private void setTranslucentStatusBar() {
        this.tintManager = new SystemBarTintManager((Activity)this);
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().setStatusBarColor(this.getTranslucentStatusBarColor());
        } else if (Build.VERSION.SDK_INT >= 19) {
            this.setTranslucentStatus(true);
            this.tintManager.setStatusBarTintEnabled(true);
            this.tintManager.setNavigationBarTintEnabled(true);
        }
        this.setStatusBarColorRes(this.getTranslucentStatusBarColor());
    }

    @TargetApi(value=19)
    private void setTranslucentStatus(boolean on) {
        Window win = this.getWindow();
        WindowManager.LayoutParams winParams = win.getAttributes();
        int bits = 0x4000000;
        winParams.flags = on ? (winParams.flags |= 0x4000000) : (winParams.flags &= 0xFBFFFFFF);
        win.setAttributes(winParams);
    }

    private void setStatusBarColorRes(int colorRes) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().setStatusBarColor(colorRes);
        } else {
            this.tintManager.setStatusBarTintColor(colorRes);
        }
    }

    protected void onPermissionResult(boolean result) {
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onNetWorkConnect(NetWorkConnectEvent netWorkConnect) {
        this.isNetConnected = (Boolean)netWorkConnect.getT();
        LogUtils.DLog(this.TAG, "netWorkConnect: " + netWorkConnect.getT());
        this.onNetChanged(netWorkConnect);
    }

    protected void onNetChanged(NetWorkConnectEvent netWorkConnectEvent) {
    }

    public boolean isContainsMainActivity() {
        boolean isContainsMain = false;
        if (ActivityStackManager.mActivityStack != null && ActivityStackManager.mActivityStack.size() > 0) {
            for (Activity activity : ActivityStackManager.mActivityStack) {
                if (activity == null || !activity.getClass().getName().contains("Main")) continue;
                isContainsMain = true;
                break;
            }
        }
        return isContainsMain;
    }

    public void hideSoftKeyboard() {
        View localView;
        InputMethodManager inputMethodManager = (InputMethodManager)this.getSystemService("input_method");
        if (inputMethodManager != null && (localView = this.getCurrentFocus()) != null && localView.getWindowToken() != null) {
            IBinder windowToken = localView.getWindowToken();
            inputMethodManager.hideSoftInputFromWindow(windowToken, 0);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.isDispatchTouchEvent()) {
            int downX;
            DisplayMetrics dm = this.getResources().getDisplayMetrics();
            float screenWidth = dm.widthPixels;
            float maxSlideLength = screenWidth / 13.0f;
            if (ev.getAction() == 0 && (float)(downX = (int)ev.getRawX()) <= maxSlideLength) {
                Log.d((String)"wwq", (String)("downX: " + downX));
                return this.getWindow().getDecorView().onTouchEvent(ev);
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    protected boolean isDispatchTouchEvent() {
        return false;
    }
}

