/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.common.base;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.xdja.poc.common.event.NetWorkConnectEvent;
import com.xdja.poc.common.rxpermissions2.RxPermissions;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.NetUtils;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public abstract class BaseFragment
extends Fragment {
    private View view;
    protected boolean isNetConnected;

    public <T extends View> T $(@IdRes int id2) {
        if (this.view == null) {
            throw new IllegalArgumentException("view can't is null");
        }
        return (T)this.view.findViewById(id2);
    }

    protected abstract int generateLayout();

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        EventBus.getDefault().register((Object)this);
        this.isNetConnected = NetUtils.isNetworkAvailable((Context)this.getActivity());
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.view = inflater.inflate(this.generateLayout(), container, false);
        return this.view;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView();
        this.initEvent();
    }

    protected abstract void initView();

    protected abstract void initEvent();

    protected abstract void switchViewStatus(int var1);

    public void onDestroy() {
        super.onDestroy();
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onNetWorkConnect(NetWorkConnectEvent netWorkConnect) {
        this.isNetConnected = (Boolean)netWorkConnect.getT();
        this.onNetChanged(netWorkConnect);
    }

    protected void onNetChanged(NetWorkConnectEvent netWorkConnectEvent) {
    }

    public void checkPermision(String ... permissions) {
        try {
            RxPermissions rxPermissions = new RxPermissions(this);
            rxPermissions.request(permissions).subscribe(granted -> {
                if (granted.booleanValue()) {
                    this.onPermissionResult(true);
                } else {
                    this.onPermissionResult(false);
                }
            });
        }
        catch (Throwable e) {
            LogUtils.ELog(e);
        }
    }

    protected void onPermissionResult(boolean result) {
    }
}

