/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.common.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.telephony.TelephonyManager;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.StringUtils;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommonUtils {
    private static Properties pro;
    private static final String TAG = "CommonUtils";
    private static final String ERROR_PASSWORD_CHAR_REGEX = "[^0-9A-Za-z`~!@#$%^&*()\\-_+=\\[\\]{}\\\\|;:'\",<.>/?]";
    private static final Pattern ERROR_PASSWORD_PATTERN;
    private static final String ERROR_ACCOUNT_CHAR_REGEX = "[^0-9A-Za-z]";
    private static final Pattern ERROR_ACCOUNT_PATTERN;

    public static boolean checkAccountRegex(String account) {
        return !ERROR_ACCOUNT_PATTERN.matcher(account).find();
    }

    public static boolean checkPasswordRegex(String password) {
        return !ERROR_PASSWORD_PATTERN.matcher(password).find();
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getIMEI(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String imei = telephonyManager.getDeviceId() + 123;
        LogUtils.DLog(TAG, "getIMEI: imei is " + imei);
        return imei;
    }

    public static String getVersionCode(Context context) {
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo info = manager.getPackageInfo(context.getPackageName(), 0);
            if (info != null) {
                String version = info.versionName;
                return version;
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean checkCellphone(String cellphone) {
        String regex = "^(13[0-9]|14[579]|15[0-3,5-9]|16[6]|17[0135678]|18[0-9]|19[89])\\d{8}$";
        return CommonUtils.check(cellphone, regex);
    }

    public static boolean checkTelephone(String telephone) {
        String regex = "^(0\\d{2}-\\d{8}(-\\d{1,4})?)|(0\\d{3}-\\d{7,8}(-\\d{1,4})?)$";
        return CommonUtils.check(telephone, regex);
    }

    private static boolean check(String cellphone, String regex) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(cellphone);
        return m.matches();
    }

    public static Properties readProperties(Context context, String name) {
        if (StringUtils.isEmpty(name)) {
            throw new IllegalArgumentException("Properties name can not null");
        }
        if (pro != null) {
            return pro;
        }
        try {
            pro = new Properties();
            InputStream in = context.getAssets().open(name);
            pro.load(in);
            return pro;
        }
        catch (Exception e) {
            LogUtils.ELog(e);
            return null;
        }
    }

    public static boolean containsEmoji(String source) {
        int len = source.length();
        for (int i = 0; i < len; ++i) {
            char codePoint = source.charAt(i);
            if (CommonUtils.isEmojiCharacter(codePoint)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmojiCharacter(char codePoint) {
        return codePoint == '\u0000' || codePoint == '\t' || codePoint == '\n' || codePoint == '\r' || codePoint >= ' ' && codePoint <= '\ud7ff' || codePoint >= '\ue000' && codePoint <= '\ufffd' || codePoint >= '\u10000' && codePoint <= '\u10ffff';
    }

    static {
        ERROR_PASSWORD_PATTERN = Pattern.compile(ERROR_PASSWORD_CHAR_REGEX);
        ERROR_ACCOUNT_PATTERN = Pattern.compile(ERROR_ACCOUNT_CHAR_REGEX);
    }
}

