/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.common.utils;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

@SuppressLint(value={"SimpleDateFormat"})
public class DateUtils {
    public static String[] WEEK = new String[]{"\u5929", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d"};
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    private static String[] weeks = new String[]{"\u7b2c\u4e00\u5468", "\u7b2c\u4e8c\u5468", "\u7b2c\u4e09\u5468", "\u7b2c\u56db\u5468", "\u7b2c\u4e94\u5468"};
    private static String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public static Date string2Date(String str, String format) {
        try {
            return new SimpleDateFormat(format).parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static String getWeek(Date date) {
        String[] weeks = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int week_index = cal.get(7) - 1;
        if (week_index < 0) {
            week_index = 0;
        }
        return weeks[week_index];
    }

    public static String getEngWeek(Date date) {
        String[] weeks = new String[]{"Sunday", "Monday ", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int week_index = cal.get(7) - 1;
        if (week_index < 0) {
            week_index = 0;
        }
        return weeks[week_index];
    }

    public static String getWeekNew(Date date) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        boolean isFirstSunday = now.getFirstDayOfWeek() == 1;
        int weekDay = now.get(7);
        if (isFirstSunday && --weekDay == 0) {
            weekDay = 7;
        }
        String[] weeks = new String[]{"\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d", "\u661f\u671f\u65e5"};
        return weeks[weekDay - 1];
    }

    public static String string2String(String str, String format, String secondFormat) {
        try {
            return DateUtils.date2String(new SimpleDateFormat(format).parse(str).getTime(), secondFormat);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date().toString();
        }
    }

    public static String date2String(long time, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(time);
    }

    public static long getYearMonthDay(long date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date);
        calendar.set(11, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static String getTimestampString(Date date) {
        Date curDate = new Date();
        long splitTime = curDate.getTime() - date.getTime();
        if (splitTime < 2592000000L) {
            if (splitTime < 60000L) {
                return "\u521a\u521a";
            }
            if (splitTime < 3600000L) {
                return String.format("%d\u5206\u949f\u524d", splitTime / 60000L);
            }
            if (splitTime < 86400000L) {
                return String.format("%d\u5c0f\u65f6\u524d", splitTime / 3600000L);
            }
            return String.format("%d\u5929\u524d", splitTime / 86400000L);
        }
        String result = "M\u6708d\u65e5 HH:mm";
        return new SimpleDateFormat(result, Locale.CHINA).format(date);
    }

    public static String generateTimeExculdeDay(Date date) {
        Date curDate = new Date();
        long splitTime = curDate.getTime() - date.getTime();
        if (splitTime < 2592000000L) {
            if (splitTime < 60000L) {
                return "\u521a\u521a";
            }
            if (splitTime < 3600000L) {
                return String.format("%d\u5206\u949f\u524d", splitTime / 60000L);
            }
            if (splitTime < 86400000L) {
                return String.format("%d\u5c0f\u65f6\u524d", splitTime / 3600000L);
            }
        }
        String result = "MM\u6708dd\u65e5 HH:mm";
        return new SimpleDateFormat(result, Locale.CHINA).format(date);
    }

    public static String generateDayTime(Date date) {
        return new SimpleDateFormat("MM\u6708dd\u65e5 HH:mm", Locale.CHINA).format(date);
    }

    public static String time24To12(String time) {
        String sx;
        String[] str = time.split(":");
        int h = Integer.valueOf(str[0]);
        int m = Integer.valueOf(str[1]);
        if (h < 1) {
            h = 12;
            sx = "\u4e0a\u5348";
        } else if (h < 12) {
            sx = "\u4e0a\u5348";
        } else if (h < 13) {
            sx = "\u4e0b\u5348";
        } else {
            sx = "\u4e0b\u5348";
            h -= 12;
        }
        return String.format("%d:%02d%s", h, m, sx);
    }

    public static String date2HH(Date date) {
        return new SimpleDateFormat("HH").format(date);
    }

    public static String date2DD(Date date) {
        return new SimpleDateFormat("dd").format(date);
    }

    public static String date2HHmm(Date date) {
        return new SimpleDateFormat("HH:mm").format(date);
    }

    public static String date2HHmmss(Date date) {
        return new SimpleDateFormat("HH:mm:ss").format(date);
    }

    public static String dateMMddhhmm(Date date) {
        return new SimpleDateFormat("MM\u6708dd\u65e5 HH:mm").format(date);
    }

    public static String date2MMdd(Date date) {
        return new SimpleDateFormat("MM.dd").format(date);
    }

    public static String date2MMdd2(Date date) {
        return new SimpleDateFormat("M\u6708d\u65e5").format(date);
    }

    public static String time2eekAndDate(long time) {
        return new SimpleDateFormat("M\u6708dd\u65e5").format(new Date(time));
    }

    public static String date2MM(Date date) {
        return new SimpleDateFormat("MM").format(date);
    }

    public static String date2yy(Date date) {
        return new SimpleDateFormat("yyyy").format(date).substring(2);
    }

    public static String getTime(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("MM");
        return format.format(date);
    }

    public static int getMonthSimple(Date date) {
        String time2 = DateUtils.getTime(date);
        int i = Integer.parseInt(time2);
        return i;
    }

    public static String getTime2(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        String year = format.format(date);
        return year.substring(2);
    }

    public static String getTime3(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        return format.format(date);
    }

    public static String getDay(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("dd");
        return format.format(date);
    }

    public static String getTime4(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(date);
    }

    public static String getTime6(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd");
        return format.format(date);
    }

    public static String getTime5(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        return format.format(date);
    }

    public static String getEndDate(int year, int month, int startDay, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, startDay);
        calendar.add(5, days);
        Date end = calendar.getTime();
        return DateUtils.getTime4(end);
    }

    public static String getStartDate(int year, int month, int week) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, 1);
        int i = 1;
        while (calendar.get(7) != 2) {
            calendar.set(5, i++);
        }
        calendar.add(5, (week - 1) * 7);
        Date time = calendar.getTime();
        return DateUtils.getTime4(time);
    }

    @NonNull
    public static String formatMonth(String time) {
        int i = 0;
        try {
            i = Integer.parseInt(time);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return i + "";
    }

    public static String date2yyyyMM(Date date) {
        return new SimpleDateFormat("yyyyMM").format(date);
    }

    public static String date2MMddWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        return new SimpleDateFormat("MM\u6708dd\u65e5 \u661f\u671f").format(date) + WEEK[dayOfWeek - 1];
    }

    public static String date2yyyyMMddWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        return new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 \u661f\u671f").format(date) + WEEK[dayOfWeek - 1];
    }

    public static String dateToyyyyMMdd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        return new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5").format(date);
    }

    public static String getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, cal.getActualMaximum(5));
        return new SimpleDateFormat("yyyy-MM-dd").format(cal.getTime());
    }

    public static String getFirstDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, cal.getMinimum(5));
        return new SimpleDateFormat("yyyy-MM-dd").format(cal.getTime());
    }

    public static String getMonthWeek(int week) {
        return weeks[week];
    }

    public static String getTime2Now(String oldTime) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            long old = format.parse(oldTime).getTime();
            long now = System.currentTimeMillis();
            long diff = now - old;
            long days = diff / 86400000L;
            long hours = (diff - days * 86400000L) / 3600000L;
            long minutes = (diff - days * 86400000L - hours * 3600000L) / 60000L;
            if (days > 0L) {
                return days + "\u5929" + hours + "\u5c0f\u65f6" + minutes + "\u5206";
            }
            if (hours > 0L) {
                return hours + "\u5c0f\u65f6" + minutes + "\u5206";
            }
            return minutes + "\u5206";
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getWaitTime(String oldTime, String newTime) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            long old = format.parse(oldTime).getTime();
            long now = format.parse(newTime).getTime();
            long diff = now - old;
            long days = diff / 86400000L;
            long hours = (diff - days * 86400000L) / 3600000L;
            long minutes = (diff - days * 86400000L - hours * 3600000L) / 60000L;
            if (days > 0L) {
                return days + "\u5929" + hours + "\u5c0f\u65f6" + minutes + "\u5206";
            }
            if (hours > 0L) {
                return hours + "\u5c0f\u65f6" + minutes + "\u5206";
            }
            return minutes + "\u5206";
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getYesterday(Date date) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.add(5, -1);
        return DateUtils.getTime4(instance.getTime());
    }

    public static String formateTime(int time) {
        long hour = time / 3600;
        long minute = ((long)time - hour * 60L * 60L) / 60L;
        long second = (long)time - hour * 60L * 60L - minute * 60L;
        String sh = "";
        String sm = "";
        String ss = "";
        sh = hour < 10L ? "0" + String.valueOf(hour) : String.valueOf(hour);
        sm = minute < 10L ? "0" + String.valueOf(minute) : String.valueOf(minute);
        ss = second < 10L ? "0" + String.valueOf(second) : String.valueOf(second);
        return sh + ":" + sm + ":" + ss;
    }

    public static String getMonthEng(Date date) {
        String month = DateUtils.getTime(date);
        int i = Integer.parseInt(month);
        return months[i - 1];
    }

    public static boolean isToday(Date day) {
        int diffDay;
        Calendar pre = Calendar.getInstance();
        Date predate = new Date(System.currentTimeMillis());
        pre.setTime(predate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(day);
        return cal.get(1) == pre.get(1) && (diffDay = cal.get(6) - pre.get(6)) == 0;
    }

    public static String getTime7(long start, long end) {
        Date startDate = new Date(start);
        Date endDate = new Date(end);
        String s = "" + DateUtils.getTime(startDate) + "/" + DateUtils.getDay(startDate) + "-" + DateUtils.getTime(endDate) + "/" + DateUtils.getDay(endDate);
        return s;
    }

    public static String getFormatedPassedTime(long createTime) {
        long differentMilliSeconds = System.currentTimeMillis() - createTime;
        long secondsInMilli = 1000L;
        long minutesInMilli = secondsInMilli * 60L;
        long hoursInMilli = minutesInMilli * 60L;
        long elapsedSeconds = differentMilliSeconds / secondsInMilli;
        if (elapsedSeconds <= 60L) {
            return "\u521a\u521a";
        }
        long elapsedMinutes = differentMilliSeconds / minutesInMilli;
        if (elapsedSeconds <= 3600L) {
            return elapsedMinutes + "\u5206\u949f\u524d";
        }
        long elapsedHours = differentMilliSeconds / hoursInMilli;
        if (elapsedMinutes <= 1440L) {
            return elapsedHours + "\u5c0f\u65f6\u524d";
        }
        SimpleDateFormat format = new SimpleDateFormat("M\u6708dd\u65e5 HH:mm");
        return format.format(new Date(createTime));
    }
}

