/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.common.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.LogUtils;
import java.util.UUID;

public class DeviceUtils {
    public static String TAG = "DeviceUtils";

    @SuppressLint(value={"MissingPermission"})
    public static String getImei(Context context) {
        String imei = "";
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            imei = tm.getDeviceId() + "poc";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return imei;
    }

    public static int getAppVersionCode(Context context) {
        int version = 0;
        try {
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            version = pInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException localNameNotFoundException) {
            LogUtils.ELog(localNameNotFoundException);
        }
        return version;
    }

    public static String getDeviceId(Context context) {
        String serial = null;
        String m_szDevIDShort = "35" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10 + Build.CPU_ABI.length() % 10 + Build.DEVICE.length() % 10 + Build.DISPLAY.length() % 10 + Build.HOST.length() % 10 + Build.ID.length() % 10 + Build.MANUFACTURER.length() % 10 + Build.MODEL.length() % 10 + Build.PRODUCT.length() % 10 + Build.TAGS.length() % 10 + Build.TYPE.length() % 10 + Build.USER.length() % 10;
        try {
            serial = Build.class.getField("SERIAL").get(null).toString();
            return new UUID(m_szDevIDShort.hashCode(), serial.hashCode()).toString() + "_poc";
        }
        catch (Exception exception) {
            serial = DeviceUtils.getImei(context);
            return new UUID(m_szDevIDShort.hashCode(), serial.hashCode()).toString() + "_poc";
        }
    }

    public static void gainAudioFocus() {
        AudioManager mAudioManager = (AudioManager)GlobalContext.getContext().getSystemService("audio");
        int result = mAudioManager.requestAudioFocus(null, 3, 1);
        LogUtils.DLog(TAG, "gain audio focus: " + result);
    }

    public static void releaseAudioFocus() {
        AudioManager audioManager = (AudioManager)GlobalContext.getContext().getSystemService("audio");
        int result = audioManager.abandonAudioFocus(null);
        LogUtils.DLog(TAG, "release audio focus: " + result);
    }

    public static synchronized String getAppName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            int labelRes = packageInfo.applicationInfo.labelRes;
            return context.getResources().getString(labelRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized Bitmap getBitmap(Context context) {
        PackageManager packageManager = null;
        ApplicationInfo applicationInfo = null;
        try {
            packageManager = context.getApplicationContext().getPackageManager();
            applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            applicationInfo = null;
        }
        Drawable d = packageManager.getApplicationIcon(applicationInfo);
        BitmapDrawable bd = (BitmapDrawable)d;
        Bitmap bm = bd.getBitmap();
        return bm;
    }
}

