/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.common.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

public class NetUtils {
    public static final int NETWORK_NONE = 0;
    public static final int NETWORK_WIFI = 1;
    public static final int NETWORK_MOBILE = 2;

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    public static NetworkInfo.State getCurrentNetworkState(Context context) {
        NetworkInfo networkInfo = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
        return networkInfo != null ? networkInfo.getState() : null;
    }

    public static boolean isConnectedByState(Context context) {
        return NetUtils.getCurrentNetworkState(context) == NetworkInfo.State.CONNECTED;
    }

    public static boolean isConnectingByState(Context context) {
        return NetUtils.getCurrentNetworkState(context) == NetworkInfo.State.CONNECTING;
    }

    public static boolean isDisconnectedByState(Context context) {
        return NetUtils.getCurrentNetworkState(context) == NetworkInfo.State.DISCONNECTED;
    }

    private static boolean isMobileNetworkConnected(Context context) {
        ConnectivityManager mConnectivityManager;
        NetworkInfo mNetworkInfo;
        if (context != null && (mNetworkInfo = (mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null) {
            return mNetworkInfo.isConnected();
        }
        return false;
    }

    private boolean isWifiConnected(Context context) {
        ConnectivityManager mConnectivityManager;
        NetworkInfo mWiFiNetworkInfo;
        if (context != null && (mWiFiNetworkInfo = (mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getNetworkInfo(1)) != null) {
            return mWiFiNetworkInfo.isConnected();
        }
        return false;
    }

    public static int getNetworkState(Context context) {
        NetworkInfo.State state;
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetInfo = connManager.getActiveNetworkInfo();
        if (null == connManager) {
            return 0;
        }
        if (activeNetInfo == null || !activeNetInfo.isAvailable()) {
            return 0;
        }
        NetworkInfo wifiInfo = connManager.getNetworkInfo(1);
        if (null != wifiInfo && null != (state = wifiInfo.getState()) && (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING)) {
            return 1;
        }
        return 2;
    }
}

