/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.common.utils;

import com.xdja.poc.common.utils.StringUtils;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinyinUtil {
    public static String getPingYin(String src) {
        if (src == null) {
            return "#";
        }
        char[] t1 = src.toCharArray();
        String[] t2 = new String[t1.length];
        HanyuPinyinOutputFormat t3 = new HanyuPinyinOutputFormat();
        t3.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        t3.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        t3.setVCharType(HanyuPinyinVCharType.WITH_U_UNICODE);
        StringBuffer t4 = new StringBuffer();
        int t0 = t1.length;
        try {
            for (int i = 0; i < t0; ++i) {
                if (Character.toString(t1[i]).matches("[\\u4E00-\\u9FA5]+")) {
                    t2 = PinyinHelper.toHanyuPinyinStringArray((char)t1[i], (HanyuPinyinOutputFormat)t3);
                    if (t2 == null) continue;
                    t4.append(t2[0]);
                    continue;
                }
                t4.append(Character.toString(t1[i]));
            }
            return t4.toString();
        }
        catch (BadHanyuPinyinOutputFormatCombination e1) {
            e1.printStackTrace();
            return t4.toString();
        }
    }

    public static String getPinYinHeadChar(String str) {
        StringBuffer convert = new StringBuffer();
        for (int j = 0; j < str.length(); ++j) {
            char word = str.charAt(j);
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)word);
            if (pinyinArray != null) {
                convert.append(pinyinArray[0].charAt(0));
                continue;
            }
            convert.append(word);
        }
        return convert.toString();
    }

    public static String getCnASCII(String cnStr) {
        try {
            StringBuffer strBuf = new StringBuffer();
            byte[] bGBK = cnStr.getBytes("GBK");
            for (int i = 0; i < bGBK.length; ++i) {
                strBuf.append(Integer.toHexString(bGBK[i] & 0xFF));
            }
            return strBuf.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getFirstSpell(String chinese) {
        if (chinese == null) {
            return "#";
        }
        StringBuffer pybf = new StringBuffer();
        char[] arr = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] > '\u0080') {
                try {
                    String[] temp = PinyinHelper.toHanyuPinyinStringArray((char)arr[i], (HanyuPinyinOutputFormat)defaultFormat);
                    if (temp == null) continue;
                    pybf.append(temp[0].charAt(0));
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            pybf.append(arr[i]);
        }
        return pybf.toString().replaceAll("\\W", "").trim();
    }

    public static String getFullSpell(String chinese) {
        if (chinese == null) {
            return "#";
        }
        StringBuffer pybf = new StringBuffer();
        char[] arr = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] > '\u0080') {
                try {
                    pybf.append(PinyinHelper.toHanyuPinyinStringArray((char)arr[i], (HanyuPinyinOutputFormat)defaultFormat)[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    pybf.append(arr[i]);
                }
                continue;
            }
            pybf.append(arr[i]);
        }
        return pybf.toString();
    }

    public static String[] getFullSpellArray(String chinese) {
        String[] defaultResult = new String[]{chinese};
        if (chinese == null) {
            return defaultResult;
        }
        char[] arr = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] <= '\u0080') continue;
            try {
                String[] result = PinyinHelper.toHanyuPinyinStringArray((char)arr[i], (HanyuPinyinOutputFormat)defaultFormat);
                return result;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return defaultResult;
    }

    public static String getLetterChar(String content) {
        String sortString;
        String pingYin;
        if (!StringUtils.isEmpty(content) && !StringUtils.isEmpty(pingYin = PinyinUtil.getPingYin(content)) && (sortString = pingYin.substring(0, 1).toUpperCase()).matches("[A-Z]")) {
            return sortString;
        }
        return "#";
    }
}

