/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.common.utils;

import com.xdja.poc.common.utils.Base64;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RSAEncrypt {
    private static final char[] HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static void genKeyPair(String filePath) {
        KeyPairGenerator keyPairGen = null;
        try {
            keyPairGen = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        keyPairGen.initialize(10240, new SecureRandom());
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        try {
            String publicKeyString = new String(Base64.encode(publicKey.getEncoded()));
            String privateKeyString = new String(Base64.encode(privateKey.getEncoded()));
            FileWriter pubfw = new FileWriter(filePath + "/publicKey.keystore");
            FileWriter prifw = new FileWriter(filePath + "/privateKey.keystore");
            BufferedWriter pubbw = new BufferedWriter(pubfw);
            BufferedWriter pribw = new BufferedWriter(prifw);
            pubbw.write(publicKeyString);
            pribw.write(privateKeyString);
            pubbw.flush();
            pubbw.close();
            pubfw.close();
            pribw.flush();
            pribw.close();
            prifw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String loadPushlicKeyByInputStream(InputStream is) {
        String key = null;
        if (is == null) {
            return key;
        }
        try {
            byte[] bytes = new byte[is.available()];
            is.read(bytes);
            key = new String(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return key;
    }

    public static String loadPublicKeyByFile(String path) throws Exception {
        try {
            BufferedReader br = new BufferedReader(new FileReader(path + "/publicKey.keystore"));
            String readLine = null;
            StringBuilder sb = new StringBuilder();
            while ((readLine = br.readLine()) != null) {
                sb.append(readLine);
            }
            br.close();
            return sb.toString();
        }
        catch (IOException e) {
            throw new Exception("\u516c\u94a5\u6570\u636e\u6d41\u8bfb\u53d6\u9519\u8bef");
        }
        catch (NullPointerException e) {
            throw new Exception("\u516c\u94a5\u8f93\u5165\u6d41\u4e3a\u7a7a");
        }
    }

    public static RSAPublicKey loadPublicKeyByStr(String publicKeyStr) throws Exception {
        try {
            byte[] buffer = Base64.decode(publicKeyStr);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("\u65e0\u6b64\u7b97\u6cd5");
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("\u516c\u94a5\u975e\u6cd5");
        }
        catch (NullPointerException e) {
            throw new Exception("\u516c\u94a5\u6570\u636e\u4e3a\u7a7a");
        }
    }

    public static String loadPrivateKeyByFile(String path) throws Exception {
        try {
            BufferedReader br = new BufferedReader(new FileReader(path + "/privateKey.keystore"));
            String readLine = null;
            StringBuilder sb = new StringBuilder();
            while ((readLine = br.readLine()) != null) {
                sb.append(readLine);
            }
            br.close();
            return sb.toString();
        }
        catch (IOException e) {
            throw new Exception("\u79c1\u94a5\u6570\u636e\u8bfb\u53d6\u9519\u8bef");
        }
        catch (NullPointerException e) {
            throw new Exception("\u79c1\u94a5\u8f93\u5165\u6d41\u4e3a\u7a7a");
        }
    }

    public static RSAPrivateKey loadPrivateKeyByStr(String privateKeyStr) throws Exception {
        try {
            byte[] buffer = Base64.decode(privateKeyStr);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("\u65e0\u6b64\u7b97\u6cd5");
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("\u79c1\u94a5\u975e\u6cd5");
        }
        catch (NullPointerException e) {
            throw new Exception("\u79c1\u94a5\u6570\u636e\u4e3a\u7a7a");
        }
    }

    public static byte[] encrypt(RSAPublicKey publicKey, byte[] plainTextData) throws Exception {
        if (publicKey == null) {
            throw new Exception("\u52a0\u5bc6\u516c\u94a5\u4e3a\u7a7a, \u8bf7\u8bbe\u7f6e");
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("RSA/None/PKCS1Padding");
            cipher.init(1, publicKey);
            byte[] output = cipher.doFinal(plainTextData);
            return output;
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("\u65e0\u6b64\u52a0\u5bc6\u7b97\u6cd5");
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvalidKeyException e) {
            throw new Exception("\u52a0\u5bc6\u516c\u94a5\u975e\u6cd5,\u8bf7\u68c0\u67e5");
        }
        catch (IllegalBlockSizeException e) {
            throw new Exception("\u660e\u6587\u957f\u5ea6\u975e\u6cd5");
        }
        catch (BadPaddingException e) {
            throw new Exception("\u660e\u6587\u6570\u636e\u5df2\u635f\u574f");
        }
    }

    public static byte[] encrypt(RSAPrivateKey privateKey, byte[] plainTextData) throws Exception {
        if (privateKey == null) {
            throw new Exception("\u52a0\u5bc6\u79c1\u94a5\u4e3a\u7a7a, \u8bf7\u8bbe\u7f6e");
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("RSA");
            cipher.init(1, privateKey);
            byte[] output = cipher.doFinal(plainTextData);
            return output;
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("\u65e0\u6b64\u52a0\u5bc6\u7b97\u6cd5");
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvalidKeyException e) {
            throw new Exception("\u52a0\u5bc6\u79c1\u94a5\u975e\u6cd5,\u8bf7\u68c0\u67e5");
        }
        catch (IllegalBlockSizeException e) {
            throw new Exception("\u660e\u6587\u957f\u5ea6\u975e\u6cd5");
        }
        catch (BadPaddingException e) {
            throw new Exception("\u660e\u6587\u6570\u636e\u5df2\u635f\u574f");
        }
    }

    public static byte[] decrypt(RSAPrivateKey privateKey, byte[] cipherData) throws Exception {
        if (privateKey == null) {
            throw new Exception("\u89e3\u5bc6\u79c1\u94a5\u4e3a\u7a7a, \u8bf7\u8bbe\u7f6e");
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("RSA");
            cipher.init(2, privateKey);
            byte[] output = cipher.doFinal(cipherData);
            return output;
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("\u65e0\u6b64\u89e3\u5bc6\u7b97\u6cd5");
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvalidKeyException e) {
            throw new Exception("\u89e3\u5bc6\u79c1\u94a5\u975e\u6cd5,\u8bf7\u68c0\u67e5");
        }
        catch (IllegalBlockSizeException e) {
            throw new Exception("\u5bc6\u6587\u957f\u5ea6\u975e\u6cd5");
        }
        catch (BadPaddingException e) {
            throw new Exception("\u5bc6\u6587\u6570\u636e\u5df2\u635f\u574f");
        }
    }

    public static byte[] decrypt(RSAPublicKey publicKey, byte[] cipherData) throws Exception {
        if (publicKey == null) {
            throw new Exception("\u89e3\u5bc6\u516c\u94a5\u4e3a\u7a7a, \u8bf7\u8bbe\u7f6e");
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("RSA/None/PKCS1Padding");
            cipher.init(2, publicKey);
            byte[] output = cipher.doFinal(cipherData);
            return output;
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("\u65e0\u6b64\u89e3\u5bc6\u7b97\u6cd5");
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvalidKeyException e) {
            throw new Exception("\u89e3\u5bc6\u516c\u94a5\u975e\u6cd5,\u8bf7\u68c0\u67e5");
        }
        catch (IllegalBlockSizeException e) {
            throw new Exception("\u5bc6\u6587\u957f\u5ea6\u975e\u6cd5");
        }
        catch (BadPaddingException e) {
            throw new Exception("\u5bc6\u6587\u6570\u636e\u5df2\u635f\u574f");
        }
    }

    public static String byteArrayToString(byte[] data) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            stringBuilder.append(HEX_CHAR[(data[i] & 0xF0) >>> 4]);
            stringBuilder.append(HEX_CHAR[data[i] & 0xF]);
            if (i >= data.length - 1) continue;
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }
}

