/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.common.utils;

import android.content.Context;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import com.xdja.poc.common.R;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static boolean isEmpty(String content) {
        return TextUtils.isEmpty((CharSequence)content);
    }

    public static String generateContent(String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return "";
        }
        return content;
    }

    public static Spanned getSpanned(String nameOrNumber, String searchKey, Context context) {
        if (StringUtils.isEmpty(nameOrNumber)) {
            return Html.fromHtml((String)nameOrNumber);
        }
        if (StringUtils.isEmpty(searchKey)) {
            return Html.fromHtml((String)nameOrNumber);
        }
        int index = nameOrNumber.indexOf(searchKey);
        if (index == -1) {
            return Html.fromHtml((String)nameOrNumber);
        }
        int keyLength = searchKey.length();
        String start = nameOrNumber.substring(0, index);
        String middle = nameOrNumber.substring(index, index + keyLength);
        String end = nameOrNumber.substring(index + keyLength, nameOrNumber.length());
        StringBuffer sb = new StringBuffer();
        sb.append(TextUtils.htmlEncode((String)start));
        sb.append("<font color = ");
        sb.append(context.getResources().getColor(R.color.common_main_color));
        sb.append(">");
        sb.append(TextUtils.htmlEncode((String)middle));
        sb.append("</font>");
        sb.append(TextUtils.htmlEncode((String)end));
        String s = sb.toString();
        return Html.fromHtml((String)s);
    }

    public static String splitDisplayName(int size, String userName) {
        if (StringUtils.isEmpty(userName)) {
            return "";
        }
        String substring = "";
        substring = userName.length() > size ? userName.substring(0, size) + "..." : userName;
        return substring;
    }

    public static boolean filterSpecialChar(String content) {
        String regEx = "[{}\\[\\]<>\u3010\u3011\u201d\u201c\"]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(content);
        return m.find();
    }
}

