/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.common.utils;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import com.xdja.poc.common.R;
import com.xdja.poc.common.base.BaseActivity;
import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.UiUtils;

public class ToastUtils {
    private Toast toast;
    private static String TAG = "ToastUtils";
    private TextView tv;

    public static void initToast() {
        if (UiUtils.isMainThread()) {
            SingletonHolder.sInstance.init();
        } else {
            LogUtils.ELog(TAG, "toast must show on Main Thread");
        }
    }

    private void init() {
        this.toast = new Toast(GlobalContext.getContext());
        this.toast.setDuration(1);
        LayoutInflater inflate = (LayoutInflater)GlobalContext.getContext().getSystemService("layout_inflater");
        View v = inflate.inflate(R.layout.common_toast_layout, null);
        this.tv = (TextView)v.findViewById(R.id.message);
        this.toast.setView(v);
    }

    public static void showToast(String message) {
        if (UiUtils.isMainThread() && BaseActivity.isSelfActivity) {
            SingletonHolder.sInstance.show(message);
        } else {
            LogUtils.ELog(TAG, "toast must show on Main Thread");
        }
    }

    public static void showQueneToast(String message) {
        if (UiUtils.isMainThread() && BaseActivity.isSelfActivity) {
            SingletonHolder.sInstance.showQueneToast_(message);
        } else {
            LogUtils.ELog(TAG, "toast must show on Main Thread");
        }
    }

    public static void cancleToast() {
        if (UiUtils.isMainThread()) {
            SingletonHolder.sInstance.cancle();
        } else {
            LogUtils.ELog(TAG, "toast must show on Main Thread");
        }
    }

    private void showQueneToast_(String message) {
        if (UiUtils.isMainThread()) {
            Toast.makeText((Context)GlobalContext.getContext(), (CharSequence)("" + message), (int)0).show();
        } else {
            LogUtils.ELog(TAG, "toast must show on Main Thread");
        }
    }

    private void show(String message) {
        if (this.toast != null) {
            this.tv.setText((CharSequence)message);
            this.toast.setDuration(1);
            this.toast.show();
        }
    }

    private void cancle() {
        if (this.toast != null) {
            this.toast.cancel();
        } else {
            LogUtils.ELog(TAG, "toast must show on Main Thread");
        }
    }

    private static class SingletonHolder {
        static ToastUtils sInstance = new ToastUtils();

        private SingletonHolder() {
        }
    }
}

