/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.common.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import android.view.View;
import android.view.inputmethod.InputMethodManager;

public class UiUtils {
    public static boolean isMainThread() {
        return Thread.currentThread().getName().equals("main");
    }

    public static String getCurrentProcessName(Context context) {
        int myPid = Process.myPid();
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningAppProcessInfo appProcess : am.getRunningAppProcesses()) {
            if (appProcess.pid != myPid) continue;
            return appProcess.processName;
        }
        return null;
    }

    public static void hideKeyBoard(Context context, View view) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static void showKeyBoard(Context context) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        if (!imm.isActive()) {
            imm.toggleSoftInput(0, 2);
        }
    }
}

