/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.common.utils;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.DrawableTypeRequest;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.drawable.GlideDrawable;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.xdja.poc.common.R;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.view.GrayCircleImageTransformation;

public class ViewUtils {
    public static void intoView(Context context, ImageView view, String path) {
        Glide.with((Context)context).load(path).diskCacheStrategy(DiskCacheStrategy.ALL).into(view);
    }

    public static void intoView(Context context, ImageView view, @DrawableRes int id2, String path) {
        Glide.with((Context)context).load(path).placeholder(id2).diskCacheStrategy(DiskCacheStrategy.ALL).error(id2).into(view);
    }

    public static void intoTextView(TextView textView, String content) {
        textView.setText((CharSequence)StringUtils.generateContent(content));
    }

    public static void loadCircleBitmap(Context context, final String path, final View view, final int defaultRes, boolean isGray) {
        DrawableTypeRequest drawableTypeRequest = Glide.with((Context)context).load(path);
        drawableTypeRequest.bitmapTransform(new Transformation[]{new GrayCircleImageTransformation(context, isGray)});
        if (isGray) {
            drawableTypeRequest.skipMemoryCache(true);
            drawableTypeRequest.diskCacheStrategy(DiskCacheStrategy.NONE);
        }
        if (defaultRes != -1) {
            drawableTypeRequest.placeholder(defaultRes);
        }
        if (isGray) {
            drawableTypeRequest.skipMemoryCache(true);
            drawableTypeRequest.diskCacheStrategy(DiskCacheStrategy.NONE);
        }
        view.setTag(R.id.common_item_image_url, (Object)path);
        drawableTypeRequest.into((Target)new SimpleTarget<GlideDrawable>(){

            public void onResourceReady(GlideDrawable glideDrawable, GlideAnimation<? super GlideDrawable> glideAnimation) {
                Object obj = view.getTag(R.id.common_item_image_url);
                if (null == obj) {
                    return;
                }
                String url = (String)obj;
                if (url.equals(path)) {
                    if (view instanceof TextView) {
                        view.setBackground((Drawable)glideDrawable);
                    } else if (view instanceof ImageView) {
                        ((ImageView)view).setImageDrawable((Drawable)glideDrawable);
                    }
                }
            }

            public void onLoadFailed(Exception e, Drawable errorDrawable) {
                if (view instanceof TextView) {
                    view.setBackgroundResource(defaultRes);
                } else if (view instanceof ImageView) {
                    ((ImageView)view).setImageResource(defaultRes);
                }
                super.onLoadFailed(e, errorDrawable);
            }
        });
    }
}

