/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.common.view;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xdja.poc.common.R;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ViewUtils;
import com.xdja.poc.common.view.IEmptyView;

public class EmptyView
extends LinearLayout
implements IEmptyView {
    private ImageView ivIcon;
    private TextView tvConent;
    private LinearLayout llEmptyConent;

    public EmptyView(Context context) {
        this(context, null);
    }

    public EmptyView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EmptyView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        View view = layoutInflater.inflate(R.layout.common_emty_view, (ViewGroup)this, false);
        this.addView(view, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.ivIcon = (ImageView)this.findViewById(R.id.iv_icon);
        this.tvConent = (TextView)this.findViewById(R.id.tv_content);
        this.llEmptyConent = (LinearLayout)view.findViewById(R.id.ll_empty_content);
    }

    @Override
    public void init(final Configure configure, final ISpanClickListener listener) {
        if (configure == null) {
            throw new IllegalArgumentException("empty configure is can't null");
        }
        this.ivIcon.setBackgroundResource(configure.iconId);
        ViewUtils.intoTextView(this.tvConent, configure.content);
        if (!StringUtils.isEmpty(configure.clickContent)) {
            SpannableString clickString = new SpannableString((CharSequence)(" " + configure.clickContent + " "));
            clickString.setSpan((Object)new ClickableSpan(){

                public void onClick(View widget) {
                    if (listener != null) {
                        listener.onClick();
                    }
                }

                public void updateDrawState(TextPaint ds) {
                    super.updateDrawState(ds);
                    ds.setColor(configure.clickColor);
                    ds.setUnderlineText(false);
                }
            }, 0, clickString.length(), 33);
            this.tvConent.append((CharSequence)clickString);
            this.tvConent.setMovementMethod(LinkMovementMethod.getInstance());
        }
        this.tvConent.append((CharSequence)(StringUtils.isEmpty(configure.spanString) ? "" : configure.spanString));
    }

    public LinearLayout getContentView() {
        return this.llEmptyConent;
    }

    public static class Configure {
        private int iconId;
        private int clickColor;
        private String content;
        private String clickContent;
        private String spanString;

        public Configure(int iconId, int clickColor, String content, String clickContent, String spanString) {
            this.iconId = iconId;
            this.clickColor = clickColor;
            this.content = content;
            this.clickContent = clickContent;
            this.spanString = spanString;
        }

        public static class Builder {
            private int iconId;
            private int clickColor;
            private String content;
            private String clickContent;
            private String spanString;

            public Configure build() {
                return new Configure(this.iconId, this.clickColor, this.content, this.clickContent, this.spanString);
            }

            public Builder setIconId(int iconId) {
                this.iconId = iconId;
                return this;
            }

            public Builder setClickColor(int clickColor) {
                this.clickColor = clickColor;
                return this;
            }

            public Builder setContent(String content) {
                this.content = content;
                return this;
            }

            public Builder setClickContent(String clickContent) {
                this.clickContent = clickContent;
                return this;
            }

            public Builder setSpanString(String spanString) {
                this.spanString = spanString;
                return this;
            }
        }
    }

    public static interface ISpanClickListener {
        public void onClick();
    }
}

