/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.common.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Shader;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;

public class GrayCircleImageTransformation
implements Transformation<Bitmap> {
    private BitmapPool bitmapPool;
    private boolean isGray;
    private ColorMatrixColorFilter grayColorFilter;

    public GrayCircleImageTransformation(Context context) {
        this(context, false);
    }

    public GrayCircleImageTransformation(Context context, boolean isGray) {
        this.bitmapPool = Glide.get((Context)context).getBitmapPool();
        ColorMatrix colorMatrix = new ColorMatrix();
        colorMatrix.setSaturation(0.0f);
        this.grayColorFilter = new ColorMatrixColorFilter(colorMatrix);
        this.isGray = isGray;
    }

    public Resource<Bitmap> transform(Resource<Bitmap> resource, int i, int i1) {
        Bitmap source = (Bitmap)resource.get();
        int size = Math.min(source.getWidth(), source.getHeight());
        int width = (source.getWidth() - size) / 2;
        int height = (source.getHeight() - size) / 2;
        Bitmap bitmap = this.bitmapPool.get(size, size, Bitmap.Config.ARGB_8888);
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        BitmapShader shader = new BitmapShader(source, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        if (width != 0 || height != 0) {
            Matrix matrix = new Matrix();
            matrix.setTranslate((float)(-width), (float)(-height));
            shader.setLocalMatrix(matrix);
        }
        paint.setShader((Shader)shader);
        paint.setAntiAlias(true);
        if (this.isGray) {
            paint.setColorFilter((ColorFilter)this.grayColorFilter);
        }
        float r = (float)size / 2.0f;
        canvas.drawCircle(r, r, r, paint);
        return BitmapResource.obtain((Bitmap)bitmap, (BitmapPool)this.bitmapPool);
    }

    public String getId() {
        return "GrayCircleImageTransformation";
    }

    public void setGray(boolean isGray) {
        this.isGray = isGray;
    }
}

