/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.common.view;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.xdja.poc.common.R;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.view.ISearchCallBack;
import com.xdja.poc.common.view.ISearchView;
import com.xdja.poc.common.view.NoEmojEditText;

public class SearchEditView
extends LinearLayout
implements ISearchView {
    private String TAG = "SearchEditView";
    private NoEmojEditText etSearch;
    private ImageView ivClear;
    private ISearchCallBack mSearchCallBack;
    private Context mContext;

    public SearchEditView(Context context) {
        this(context, null);
        this.mContext = context;
    }

    public SearchEditView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
        this.mContext = context;
    }

    public SearchEditView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        View view = layoutInflater.inflate(R.layout.common_search_editview, (ViewGroup)this, false);
        this.addView(view, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
        this.etSearch = (NoEmojEditText)((Object)this.$(view, R.id.et_search));
        this.ivClear = (ImageView)this.$(view, R.id.iv_clear);
        this.ivClear.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SearchEditView.this.etSearch.setText("");
            }
        });
        this.etSearch.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SearchEditView.this.etSearch.setFocusable(true);
                SearchEditView.this.etSearch.setFocusableInTouchMode(true);
                SearchEditView.this.etSearch.requestFocus();
                SearchEditView.this.etSearch.findFocus();
                SearchEditView.this.showKeyBoard();
            }
        });
    }

    private <T extends View> T $(View view, @IdRes int id2) {
        return (T)view.findViewById(id2);
    }

    @Override
    public EditText getEditText() {
        return this.etSearch;
    }

    @Override
    public void setSHintText(String text) {
        this.etSearch.setHint(text);
    }

    @Override
    public void setSHintColor(@ColorInt int color2) {
        this.etSearch.setHintTextColor(color2);
    }

    @Override
    public void setIsFavorEmoj(boolean isFavor, String tips) {
        this.etSearch.setIsFavorEmoj(isFavor, tips);
    }

    @Override
    public void startSearch(String keyWords) {
    }

    @Override
    public void addTextChangeWatcher(TextWatcher textWatcher) {
        this.etSearch.addTextChangedListener(textWatcher);
    }

    @Override
    public void addTextChangeWatcher(ISearchCallBack callBack) {
        this.mSearchCallBack = callBack;
        this.etSearch.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable key) {
                if (SearchEditView.this.mSearchCallBack != null) {
                    String keyWord = key.toString();
                    if (TextUtils.isEmpty((CharSequence)keyWord)) {
                        SearchEditView.this.ivClear.setVisibility(8);
                        SearchEditView.this.mSearchCallBack.onEndSearch();
                    } else {
                        SearchEditView.this.ivClear.setVisibility(0);
                        SearchEditView.this.mSearchCallBack.onStartSearch(keyWord);
                    }
                } else {
                    LogUtils.WLog(SearchEditView.this.TAG, "must set text changed callback:addTextChangeWatcher ");
                }
            }
        });
    }

    public void clear() {
        this.etSearch.setText("");
        this.etSearch.setFocusable(false);
    }

    public void closeKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.mContext.getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.etSearch.getWindowToken(), 0);
        this.etSearch.setFocusable(false);
    }

    private void showKeyBoard() {
        InputMethodManager imm = (InputMethodManager)this.mContext.getSystemService("input_method");
        imm.showSoftInput((View)this.etSearch, 2);
    }
}

