/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.common.view;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xdja.poc.common.R;
import com.xdja.poc.common.utils.DisplayUtil;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.view.ITitleBar;

public class TitleBarView
extends LinearLayout
implements ITitleBar {
    private ImageView ivLeftBack;
    private ImageView ivRightView;
    private TextView tvTitle;
    private TextView tvRight;
    private View viewLine;
    private RelativeLayout rlTitlebg;
    private View lineView;
    private View redPoint;
    private ImageView ivLeftSecond;

    public TitleBarView(Context context) {
        this(context, null);
    }

    public TitleBarView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TitleBarView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        View view = layoutInflater.inflate(R.layout.common_tiltebar_view, (ViewGroup)this, false);
        this.addView(view, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
        this.ivLeftBack = (ImageView)this.$(view, R.id.iv_left);
        this.ivRightView = (ImageView)this.$(view, R.id.iv_right);
        this.tvTitle = (TextView)this.$(view, R.id.tv_title);
        this.viewLine = this.$(view, R.id.view_line);
        this.rlTitlebg = (RelativeLayout)this.$(view, R.id.rl_title_bg);
        this.tvRight = (TextView)this.$(view, R.id.tv_right);
        this.redPoint = this.findViewById(R.id.poc_red_point);
        this.ivLeftSecond = (ImageView)this.findViewById(R.id.iv_new_message);
        this.lineView = this.findViewById(R.id.view_line);
    }

    private <T extends View> T $(View view, @IdRes int id2) {
        return (T)view.findViewById(id2);
    }

    @Override
    public void setBackgroundRecource(@ColorRes int resid) {
        this.rlTitlebg.setBackgroundResource(resid);
    }

    public RelativeLayout getTitleBackBroundView() {
        return this.rlTitlebg;
    }

    public void setRightText(String right) {
        if (!TextUtils.isEmpty((CharSequence)right)) {
            this.ivRightView.setVisibility(8);
            this.tvRight.setVisibility(0);
            this.tvRight.setText((CharSequence)right);
        } else {
            this.ivRightView.setVisibility(8);
            this.tvRight.setVisibility(8);
        }
    }

    public void setRightTextColor(@ColorInt int color2) {
        this.tvRight.setTextColor(color2);
    }

    public void setRightTextSize(float size) {
        this.tvRight.setTextSize(size);
    }

    @Override
    public void setTile(String title) {
        this.tvTitle.setText((CharSequence)StringUtils.generateContent(title));
        this.tvTitle.setVisibility(0);
    }

    @Override
    public void setTextSize(int size) {
        this.tvTitle.setTextSize(2, (float)size);
    }

    @Override
    public void setTitleColor(@ColorInt int colorId) {
        this.tvTitle.setTextColor(colorId);
    }

    @Override
    public void setLeftViewRecource(@DrawableRes int resid) {
        this.ivLeftBack.setBackgroundResource(resid);
        this.ivLeftBack.setVisibility(0);
    }

    @Override
    public void setRightViewRecource(@DrawableRes int resid) {
        this.ivRightView.setBackgroundResource(resid);
        this.ivRightView.setVisibility(0);
        this.tvRight.setVisibility(8);
    }

    @Override
    public void setLeftViewClickListener(View.OnClickListener onClickListener) {
        this.ivLeftBack.setOnClickListener(onClickListener);
    }

    @Override
    public void setRightIVClickListener(View.OnClickListener onClickListener) {
        this.ivRightView.setOnClickListener(onClickListener);
    }

    @Override
    public void setRightTVClickListener(View.OnClickListener onClickListener) {
        this.tvRight.setOnClickListener(onClickListener);
    }

    @Override
    public void setLeftSecondClickListener(View.OnClickListener onClickListener) {
        this.ivLeftSecond.setOnClickListener(onClickListener);
    }

    @Override
    public void setLeftViewVisisable(int visiable) {
        this.ivLeftBack.setVisibility(visiable);
    }

    @Override
    public void setRightViewVisisable(int visiable) {
        this.ivRightView.setVisibility(visiable);
    }

    @Override
    public void setTitleViewVisisable(int visiable) {
        this.tvTitle.setVisibility(visiable);
    }

    @Override
    public void setLineVisiable(int visiable) {
        this.viewLine.setVisibility(visiable);
    }

    @Override
    public void setBottomLineColor(@ColorInt int colorId) {
        this.viewLine.setVisibility(0);
        this.viewLine.setBackgroundColor(colorId);
    }

    @Override
    public void setLeftSecondViewResource(@DrawableRes int resid) {
        this.ivLeftSecond.setBackgroundResource(resid);
    }

    @Override
    public void setLeftSecondViewVisiable(int visiable) {
        this.ivLeftSecond.setVisibility(0);
    }

    @Override
    public void setLeftRedPointVisiable(int visiable) {
        this.redPoint.setVisibility(visiable);
    }

    @Override
    public void setLeftRedPointSize(int size) {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.redPoint.getLayoutParams();
        layoutParams.height = DisplayUtil.dip2px(this.getContext(), size);
        layoutParams.width = DisplayUtil.dip2px(this.getContext(), size);
        this.redPoint.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    public View getRedPointView() {
        return this.redPoint;
    }

    @Override
    public RelativeLayout.LayoutParams getRedPointParams() {
        return (RelativeLayout.LayoutParams)this.redPoint.getLayoutParams();
    }
}

