/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.common.view;

import android.content.Context;
import android.support.annotation.StringRes;
import android.support.v7.app.AlertDialog;
import android.view.View;
import android.view.WindowManager;
import android.widget.EditText;
import android.widget.TextView;
import com.xdja.poc.common.R;

public class WarningDialog {
    private AlertDialog alertDialog = null;

    public void showWarningDialog(Context context, @StringRes int messageId, View.OnClickListener cancelListener, View.OnClickListener confirmListener) {
        this.showWarningDialog(context, -1, -1, messageId, cancelListener, confirmListener);
    }

    public void showWarningDialog(Context context, @StringRes int leftBtnText, @StringRes int rightBtnText, @StringRes int messageId, View.OnClickListener cancelListener, View.OnClickListener confirmListener) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        this.alertDialog = builder.create();
        View inflate = View.inflate((Context)context, (int)R.layout.common_warning_dialog_layout, null);
        TextView mBtnCancel = (TextView)inflate.findViewById(R.id.btn_dialog_cancel);
        TextView mBtnConfirm = (TextView)inflate.findViewById(R.id.btn_dialog_confirm);
        if (leftBtnText != -1) {
            mBtnCancel.setText(leftBtnText);
        }
        if (rightBtnText != -1) {
            mBtnConfirm.setText(rightBtnText);
        }
        TextView mTvMessage = (TextView)inflate.findViewById(R.id.tv_message);
        mTvMessage.setText((CharSequence)context.getString(messageId));
        builder.setCancelable(false);
        this.alertDialog.setView(inflate);
        this.alertDialog.setCanceledOnTouchOutside(false);
        mBtnCancel.setOnClickListener(cancelListener);
        mBtnConfirm.setOnClickListener(confirmListener);
        WindowManager.LayoutParams layoutParams = this.alertDialog.getWindow().getAttributes();
        this.alertDialog.show();
        layoutParams.width = this.alertDialog.getContext().getResources().getDimensionPixelSize(R.dimen.common_conversation_dialog_width);
        layoutParams.height = -2;
        this.alertDialog.getWindow().setAttributes(layoutParams);
    }

    public void showInputGroupNameDialog(Context context, @StringRes int leftBtnText, @StringRes int rightBtnText, View.OnClickListener cancelListener, final IPocGetGroupName callback) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        this.alertDialog = builder.create();
        View inflate = View.inflate((Context)context, (int)R.layout.common_warning_dialog_layout, null);
        TextView mBtnCancel = (TextView)inflate.findViewById(R.id.btn_dialog_cancel);
        TextView mBtnConfirm = (TextView)inflate.findViewById(R.id.btn_dialog_confirm);
        if (leftBtnText != -1) {
            mBtnCancel.setText(leftBtnText);
        }
        if (rightBtnText != -1) {
            mBtnConfirm.setText(rightBtnText);
        }
        inflate.findViewById(R.id.tv_message).setVisibility(8);
        final EditText mEt = (EditText)inflate.findViewById(R.id.et_room_name);
        mEt.setVisibility(0);
        builder.setCancelable(false);
        this.alertDialog.setView(inflate);
        this.alertDialog.setCanceledOnTouchOutside(false);
        mBtnCancel.setOnClickListener(cancelListener);
        mBtnConfirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                callback.pocGroupNameCallBack(mEt.getText().toString().trim());
            }
        });
        WindowManager.LayoutParams layoutParams = this.alertDialog.getWindow().getAttributes();
        this.alertDialog.show();
        layoutParams.width = this.alertDialog.getContext().getResources().getDimensionPixelSize(R.dimen.common_conversation_dialog_width);
        layoutParams.height = -2;
        this.alertDialog.getWindow().setAttributes(layoutParams);
    }

    public void dismissDialog() {
        if (this.alertDialog != null) {
            this.alertDialog.dismiss();
            this.alertDialog = null;
        }
    }

    public static interface IPocGetGroupName {
        public void pocGroupNameCallBack(String var1);
    }
}

