/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.common.view.bezier;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.view.bezier.CustomValueAnimator;

public class BezierLine
extends View {
    private static final String TAG = BezierLine.class.getSimpleName();
    private static final int LINE_COUNT = 4;
    private Paint paint;
    private CustomValueAnimator[] customValueAnimators;
    private int[] durationArray = new int[]{1500, 3000, 5000, 2000};
    private PointF startPoint;
    private PointF controlPoint1;
    private PointF endPoint1;
    private PointF controlPoint2;
    private PointF endPoint2;
    private Path path;
    private int[] offset;
    private boolean isStart;
    private WorkerThread workerThread;
    private static final int UPDATE_TIME = 30;

    public BezierLine(Context context) {
        this(context, null);
    }

    public BezierLine(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.paint = new Paint(1);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setColor(-1);
        this.startPoint = new PointF();
        this.controlPoint1 = new PointF();
        this.controlPoint2 = new PointF();
        this.endPoint1 = new PointF();
        this.endPoint2 = new PointF();
        this.path = new Path();
        this.offset = new int[4];
        this.customValueAnimators = new CustomValueAnimator[4];
        for (int i = 0; i < 4; ++i) {
            this.customValueAnimators[i] = new CustomValueAnimator();
            this.customValueAnimators[i].setDuration(this.durationArray[i]);
            this.customValueAnimators[i].setUpdateTime(30);
        }
        this.workerThread = new WorkerThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInvalidate() {
        BezierLine bezierLine = this;
        synchronized (bezierLine) {
            if (this.isStart) {
                for (int i = 0; i < 4; ++i) {
                    this.offset[i] = this.customValueAnimators[i].getValue();
                }
            }
        }
        super.postInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        BezierLine bezierLine = this;
        synchronized (bezierLine) {
            if (this.getVisibility() == 0 && !this.isStart) {
                this.isStart = true;
                for (int i = 0; i < 4; ++i) {
                    this.customValueAnimators[i].setEndValue(this.getMeasuredWidth());
                    this.customValueAnimators[i].start();
                }
                this.workerThread.start();
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawColor(0);
        int height = this.getHeight();
        int width = this.getWidth();
        int deltaX = width / 4;
        int deltaY = height / 8;
        int lineHeight = height / 2;
        int curDeltaY = height / 2;
        this.path.reset();
        for (int i = 0; i < 4; ++i) {
            if (i == 0) {
                this.paint.setAlpha(229);
            } else if (i == 1) {
                this.paint.setAlpha(153);
            } else if (i == 2) {
                this.paint.setAlpha(76);
            } else {
                this.paint.setAlpha(50);
            }
            lineHeight = i == 0 ? (lineHeight += deltaY) : (i == 1 ? (lineHeight -= deltaY) : (lineHeight += deltaY));
            this.startPoint.set((float)this.offset[i], (float)lineHeight);
            this.controlPoint1.set(this.startPoint.x - (float)deltaX, this.startPoint.y + (float)curDeltaY);
            this.endPoint1.set(this.controlPoint1.x - (float)deltaX, this.startPoint.y);
            this.controlPoint2.set(this.endPoint1.x - (float)deltaX, this.startPoint.y - (float)curDeltaY);
            this.endPoint2.set(this.controlPoint2.x - (float)deltaX, this.startPoint.y);
            this.path.moveTo(this.startPoint.x, this.startPoint.y);
            this.path.quadTo(this.controlPoint1.x, this.controlPoint1.y, this.endPoint1.x, this.endPoint1.y);
            this.path.moveTo(this.endPoint1.x, this.endPoint1.y);
            this.path.quadTo(this.controlPoint2.x, this.controlPoint2.y, this.endPoint2.x, this.endPoint2.y);
            canvas.drawPath(this.path, this.paint);
            this.controlPoint1.set(this.startPoint.x + (float)deltaX, this.startPoint.y - (float)curDeltaY);
            this.endPoint1.set(this.controlPoint1.x + (float)deltaX, this.startPoint.y);
            this.controlPoint2.set(this.endPoint1.x + (float)deltaX, this.startPoint.y + (float)curDeltaY);
            this.endPoint2.set(this.controlPoint2.x + (float)deltaX, this.startPoint.y);
            this.path.moveTo(this.startPoint.x, this.startPoint.y);
            this.path.quadTo(this.controlPoint1.x, this.controlPoint1.y, this.endPoint1.x, this.endPoint1.y);
            this.path.moveTo(this.endPoint1.x, this.endPoint1.y);
            this.path.quadTo(this.controlPoint2.x, this.controlPoint2.y, this.endPoint2.x, this.endPoint2.y);
            canvas.drawPath(this.path, this.paint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDetachedFromWindow() {
        BezierLine bezierLine = this;
        synchronized (bezierLine) {
            this.isStart = false;
        }
        super.onDetachedFromWindow();
    }

    private class WorkerThread
    extends Thread {
        private WorkerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block5: while (true) {
                try {
                    while (true) {
                        Thread.sleep(30L);
                        BezierLine bezierLine = BezierLine.this;
                        synchronized (bezierLine) {
                            if (!BezierLine.this.isStart) {
                                LogUtils.ILog(TAG, "thread stop");
                                break block5;
                            }
                        }
                        BezierLine.this.postInvalidate();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

