package com.xdja.poc.common.base;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.support.annotation.ColorRes;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.poc.common.R;
import com.xdja.poc.common.annotation.TitleViewAnnotation;
import com.xdja.poc.common.event.CancelNotification;
import com.xdja.poc.common.event.NetWorkConnectEvent;
import com.xdja.poc.common.rxpermissions2.RxPermissions;
import com.xdja.poc.common.style.SystemBarTintManager;
import com.xdja.poc.common.utils.DisplayUtil;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.NetUtils;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.common.view.TitleBarView;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.util.Locale;

/**
 * Created by Administrator on 2018/8/27.
 */

public abstract class BaseActivity extends AppCompatActivity {
    public String TAG;
    private LinearLayout parent;
    public TitleBarView titleBarView;
    protected boolean isNetConnected;
    public static boolean isSelfActivity;
    public Toast toast;
    private TextView tvMsg;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        TAG = getClass().getName();
        if (this.getClass().isAnnotationPresent(TitleViewAnnotation.class)) {
            createRootView();
        } else {
            setContentView(generateLayout());
        }
        setTranslucentStatusBar();
        isNetConnected = NetUtils.isNetworkAvailable(this);
        initView();
        initEvent();
        EventBus.getDefault().register(this);
//        if (this.getClass().isAnnotationPresent(PermissionCheck.class)) {
//            checkPermision(Manifest.permission.WRITE_EXTERNAL_STORAGE,
//                    Manifest.permission.READ_PHONE_STATE,
//                    Manifest.permission.RECORD_AUDIO,
//                    Manifest.permission.ACCESS_NETWORK_STATE);
//        } else {
//            LogUtils.ILog(TAG, "不用检查权限。。。");
//        }

        ActivityStackManager.getInstance().addActivity(this);
        initToast();
    }

    private void initToast() {
        toast = new Toast(this);
        toast.setDuration(Toast.LENGTH_SHORT);
        LayoutInflater inflate = (LayoutInflater) getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View v = inflate.inflate(R.layout.common_toast_layout, null);
        tvMsg = v.findViewById(R.id.message);
        toast.setView(v);
    }

    public void showMessage(String message) {
        tvMsg.setText(message);
        toast.setDuration(Toast.LENGTH_SHORT);
        toast.show();
    }

    private void createRootView() {
        //1 创建根布局
        parent = new LinearLayout(this);
        parent.setOrientation(LinearLayout.VERTICAL);
        parent.setBackgroundColor(getResources().getColor(R.color.common_white_color));
        parent.setLayoutParams(new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
        //2 创建titleBarView
        titleBarView = new TitleBarView(this);
        int titleBarHeight = DisplayUtil.dip2px(this, 53);
        LinearLayout.LayoutParams titleParams = new LinearLayout.LayoutParams(
                ViewGroup.LayoutParams.MATCH_PARENT, titleBarHeight);
        parent.addView(titleBarView, titleParams);
        setContentView(parent);
        //3 添加主布局
        if (generateLayout() != -1) {
            try {
                View view = getLayoutInflater().inflate(generateLayout(), null);
                parent.addView(view, new LinearLayout.LayoutParams(
                        ViewGroup.LayoutParams.MATCH_PARENT,
                        ViewGroup.LayoutParams.MATCH_PARENT));
            } catch (Throwable throwable) {
                LogUtils.ELog(throwable);
                finish();
            }
        }
    }
    protected abstract int getTranslucentStatusBarColor() ;
    /**
     * 检查权限
     */
    public void checkPermision(String... permissions) {
        try {
            RxPermissions rxPermissions = new RxPermissions(this);
            rxPermissions.request(permissions)
                    .subscribe(granted -> {
                        if (granted) {
                            LogUtils.ILog(TAG, "granted:" + granted);
                            onPermissionResult(true);
                        } else {
                            //没有权限,显示登录界面
                            LogUtils.ILog(TAG, "granted:" + granted);
                            onPermissionResult(false);
                        }
                    });
        } catch (Throwable e) {
            LogUtils.ELog(e);
        }

    }

    protected abstract void initView();

    protected abstract void initEvent();

    protected abstract int generateLayout();

    protected TitleBarView getTitleBarView() {
        return titleBarView;
    }

    public <T extends View> T $(@IdRes int id) {
        return findViewById(id);
    }

    @Override
    protected void onResume() {
        super.onResume();
        BaseActivity.isSelfActivity = true;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (EventBus.getDefault().isRegistered(this)) {
            EventBus.getDefault().unregister(this);
        }
        ActivityStackManager.getInstance().finishActivity(this);
    }

    @Override
    public Resources getResources() {
        Resources res = super.getResources();
        Configuration configuration = res.getConfiguration();//modify by xnn @20170303 review by tangsha
        configuration.setLocale(Locale.CHINA);
        configuration.fontScale = 1.0f;
        try {
            res.updateConfiguration(configuration, res.getDisplayMetrics());
        } catch (Exception ex) {
            LogUtils.ELog(ex);
        }
        return res;
    }

    private SystemBarTintManager tintManager;

    private void setTranslucentStatusBar() {
        tintManager = new SystemBarTintManager(this);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            getWindow().setStatusBarColor(getTranslucentStatusBarColor());
        } else {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                setTranslucentStatus(true);
                tintManager.setStatusBarTintEnabled(true);
                tintManager.setNavigationBarTintEnabled(true);
            }
        }
        setStatusBarColorRes(getTranslucentStatusBarColor());
    }

    @TargetApi(19)
    private void setTranslucentStatus(boolean on) {
        Window win = getWindow();
        WindowManager.LayoutParams winParams = win.getAttributes();
        final int bits = WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS;
        if (on) {
            winParams.flags |= bits;
        } else {
            winParams.flags &= ~bits;
        }
        win.setAttributes(winParams);
    }

    private void setStatusBarColorRes( int colorRes) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            getWindow().setStatusBarColor(colorRes);
        } else {
            tintManager.setStatusBarTintColor(colorRes);
        }
    }

    /**
     * 权限检查回调方法
     *
     * @param result
     */
    protected void onPermissionResult(boolean result) {

    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onNetWorkConnect(NetWorkConnectEvent netWorkConnect) {
        isNetConnected = (boolean) netWorkConnect.getT();
        LogUtils.DLog(TAG, "netWorkConnect: " + netWorkConnect.getT());
        onNetChanged(netWorkConnect);
    }

    /**
     * 网络变化监听
     */
    protected void onNetChanged(NetWorkConnectEvent netWorkConnectEvent) {

    }

//    @Override
//    public boolean onKeyDown(int keyCode, KeyEvent event) {
//        if(keyCode==KeyEvent.KEYCODE_BACK){
//            if (getClass().getName().contains("Login") || getClass().getName().contains("Main")) {
//                EventBus.getDefault().post(new CancelNotification(true));
//                isSelfActivity = false;
//            }
//        }
//        return super.onKeyDown(keyCode, event);
//    }

    /**
     * 判断主界面有没有在堆栈里,有则false,无则true,
     *
     * @return
     */
    public boolean isContainsMainActivity() {
        boolean isContainsMain = false;
        if (ActivityStackManager.mActivityStack != null && ActivityStackManager.mActivityStack.size() > 0) {
            for (Activity activity : ActivityStackManager.mActivityStack) {
                if (activity != null && activity.getClass().getName().contains("Main")) {
                    isContainsMain = true;
                    break;
                }
            }
        }
        return isContainsMain;
    }

    public void hideSoftKeyboard() {
        InputMethodManager inputMethodManager = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
        if (inputMethodManager != null) {
            View localView = getCurrentFocus();
            if (localView != null && localView.getWindowToken() != null) {
                IBinder windowToken = localView.getWindowToken();
                inputMethodManager.hideSoftInputFromWindow(windowToken, 0);
            }
        }
    }
    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
//        DisplayMetrics dm = getResources().getDisplayMetrics();
//        float screenWidth = dm.widthPixels;
        float maxSlideLength = DisplayUtil.dip2px(this,10); // 这里我设置为 屏宽/12
        if (ev.getAction() == MotionEvent.ACTION_DOWN) {
            int downX = (int) ev.getRawX(); // 更新按下点的X轴坐标
            if (downX <= maxSlideLength) { // 检验是否从边缘开始滑动
                Log.d("wwq", "downX: " + downX);
                return getWindow().getDecorView().onTouchEvent(ev);
            }
        }
        return super.dispatchTouchEvent(ev);
    }
}
