package com.xdja.poc.common.base;

import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.xdja.poc.common.R;
import com.xdja.poc.common.annotation.BindEventBus;
import com.xdja.poc.common.event.NetWorkConnectEvent;
import com.xdja.poc.common.rxpermissions2.RxPermissions;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.NetUtils;
import com.xdja.poc.common.utils.ToastUtils;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

/**
 * janus-gateway-android-master
 * Administrator
 * 2018/8/27
 */
public abstract class BaseFragment extends Fragment {
    private View view;
    protected boolean isNetConnected;

    public <T extends View> T $(@IdRes int id) {
        if (view == null) {
            throw new IllegalArgumentException("view can't is null");
        }
        return view.findViewById(id);
    }

    protected abstract int generateLayout();

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
//        if (this.getClass().isAnnotationPresent(BindEventBus.class)) {
        EventBus.getDefault().register(this);
//        }
        isNetConnected = NetUtils.isNetworkAvailable(getActivity());
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        view = inflater.inflate(generateLayout(), container, false);
        return view;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initView();
        initEvent();
    }

    protected abstract void initView();

    protected abstract void initEvent();

    protected abstract void switchViewStatus(int status);

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (EventBus.getDefault().isRegistered(this)) {
            EventBus.getDefault().unregister(this);
        }
    }


    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onNetWorkConnect(NetWorkConnectEvent netWorkConnect) {
        isNetConnected = (boolean) netWorkConnect.getT();
        onNetChanged(netWorkConnect);
    }

    /**
     * 网络变化监听
     *
     * @param netWorkConnectEvent true:连接 false 断开
     */
    protected void onNetChanged(NetWorkConnectEvent netWorkConnectEvent) {

    }

    /**
     * 检查权限
     */
    public void checkPermision(String... permissions) {
        try {
            RxPermissions rxPermissions = new RxPermissions(this);
            rxPermissions.request(permissions)
                    .subscribe(granted -> {
                        if (granted) {
                            onPermissionResult(true);
                        } else {
                            //没有权限,显示登录界面
                            onPermissionResult(false);
                        }
                    });
        } catch (Throwable e) {
            LogUtils.ELog(e);
        }
    }

    /**
     * 权限检查回调方法
     *
     * @param result
     */
    protected void onPermissionResult(boolean result) {

    }

}
