package com.xdja.poc.common.base;

import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;

/**
 * janus-gateway-android-master
 * 功能 通过scheme传值的可继承这个baseActivity
 * 描述
 * created by Wwq : 2018/9/28
 */

public abstract class UriBaseActivity extends BaseActivity {
    private Uri mUri;

    protected abstract void initActivity(Uri paramUri);

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.mUri == null) {
            if (savedInstanceState == null)
                this.mUri = getIntent().getData();
            else {
                this.mUri = savedInstanceState.getParcelable("POC_URI");
            }
        }
        initActivity(this.mUri);
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        outState.putParcelable("POC_URI", this.mUri);
        super.onSaveInstanceState(outState);
    }
}
